/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.steps.HostSessionStep;

public class DeleteStep
extends HostSessionStep {
    private String locationToDelete;
    private String exclusionPattern;

    public DeleteStep(Host host, String pathToDelete) {
        super(host);
        this.setDescription("Delete " + pathToDelete + " from " + host.getAddress());
        this.locationToDelete = pathToDelete;
        this.exclusionPattern = null;
    }

    public DeleteStep(Host host, String pathToDelete, String exclusionPattern) {
        super(host);
        this.setDescription("Delete " + pathToDelete + " from " + host.getAddress());
        this.locationToDelete = pathToDelete;
        this.exclusionPattern = exclusionPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession session = this.getHostSession();
        try {
            ctx.logOutput("Deleting " + this.locationToDelete);
            HostFile fileToDelete = session.getFile(this.locationToDelete);
            if (this.exclusionPattern != null) {
                boolean bl = fileToDelete.deleteRecursively(this.exclusionPattern);
                return bl;
            }
            boolean bl = fileToDelete.deleteRecursively();
            return bl;
        }
        finally {
            session.close();
        }
    }
}

