/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.ssh;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostFile;
import com.xebialabs.deployit.hostsession.ssh.SshHostSession;
import com.xebialabs.deployit.hostsession.ssh.SshScpInputStream;
import com.xebialabs.deployit.hostsession.ssh.SshScpOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SshScpHostFile
extends SshHostFile
implements HostFile {
    private Logger logger = Logger.getLogger(SshScpHostFile.class);

    public SshScpHostFile(SshHostSession session, String remotePath) {
        super(session, remotePath);
    }

    @Override
    public boolean exists() throws RuntimeIOException {
        return this.stat().exists;
    }

    @Override
    public boolean isDirectory() throws RuntimeIOException {
        return this.stat().isDirectory;
    }

    @Override
    public long length() throws RuntimeIOException {
        return this.stat().length;
    }

    @Override
    public boolean canRead() throws RuntimeIOException {
        return this.stat().canRead;
    }

    @Override
    public boolean canWrite() throws RuntimeIOException {
        return this.stat().canWrite;
    }

    @Override
    public boolean canExecute() throws RuntimeIOException {
        return this.stat().canExecute;
    }

    protected StatResults stat() throws RuntimeIOException {
        StatResults results = new StatResults();
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "ls", "-ld", this.remotePath);
        if (errno == 0) {
            results.exists = true;
            if (capturedOutput.getOutputLines().size() > 0) {
                StringTokenizer outputTokens;
                String outputLine = capturedOutput.getOutputLines().get(0);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("ls output = " + outputLine));
                }
                if ((outputTokens = new StringTokenizer(outputLine)).countTokens() < 5) {
                    throw new RuntimeIOException("ls -ld " + this.remotePath + " returned output that contains less than the expected 5 tokens");
                }
                String permissions = outputTokens.nextToken();
                String inodelinkes = outputTokens.nextToken();
                String owner = outputTokens.nextToken();
                String group = outputTokens.nextToken();
                String size = outputTokens.nextToken();
                results.isDirectory = permissions.length() >= 1 && permissions.charAt(0) == 'd';
                results.canRead = permissions.length() >= 2 && permissions.charAt(1) == 'r';
                results.canWrite = permissions.length() >= 3 && permissions.charAt(2) == 'w';
                results.canExecute = permissions.length() >= 4 && permissions.charAt(3) == 'x';
                try {
                    results.length = Integer.parseInt(size);
                }
                catch (NumberFormatException ignore) {}
            }
        } else {
            results.exists = false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Statted file " + this + " (exists=" + results.exists + ", isDirectory=" + results.isDirectory + ", length=" + results.length + ", canRead=" + results.canRead + ", canWrite=" + results.canWrite + ", canExecute=" + results.canExecute + ")"));
        }
        return results;
    }

    @Override
    public List<String> list() throws RuntimeIOException {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "ls", "-1", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot list directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listed directory " + this));
        }
        return capturedOutput.getOutputLines();
    }

    @Override
    public void mkdir() throws RuntimeIOException {
        this.mkdir(new String[0]);
    }

    @Override
    public void mkdirs() throws RuntimeIOException {
        this.mkdir(new String[]{"-p"});
    }

    protected void mkdir(String[] args) throws RuntimeIOException {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, this.makeMkdirCommand(args));
        if (errno != 0) {
            throw new RuntimeIOException("Cannot create directory or -ies " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created directory " + this));
        }
    }

    private String[] makeMkdirCommand(String[] args) {
        int numArgs = args.length;
        String[] command = new String[numArgs + 2];
        command[0] = "mkdir";
        System.arraycopy(args, 0, command, 1, numArgs);
        command[numArgs + 1] = this.remotePath;
        return command;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void moveTo(HostFile destFile) {
        if (!(destFile instanceof SshScpHostFile)) throw new RuntimeIOException("Cannot move/rename SSH/SCP file/directory " + this + " to non-SSH/SCP file/directory " + destFile);
        SshScpHostFile sshScpDestFile = (SshScpHostFile)destFile;
        if (sshScpDestFile.getSession() != this.getSession()) throw new RuntimeIOException("Cannot move/rename SSH/SCP file/directory " + this + " to SSH/SCP file/directory " + destFile + " because it is in a different session");
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "mv", this.remotePath, sshScpDestFile.getPath());
        if (errno == 0) return;
        throw new RuntimeIOException("Cannot move/rename file/directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
    }

    @Override
    protected void deleteDirectory() {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rmdir", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot delete directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted directory " + this));
        }
    }

    @Override
    protected void deleteFile() {
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rm", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot delete file " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted file " + this));
        }
    }

    @Override
    public boolean deleteRecursively() throws RuntimeIOException {
        if (!this.exists()) {
            return false;
        }
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "rm", "-rf", this.remotePath);
        if (errno != 0) {
            throw new RuntimeIOException("Cannot recursively delete directory " + this + ": " + capturedOutput.getError() + " (errno=" + errno + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Recursively deleted file/directory " + this));
        }
        return true;
    }

    protected int executeCommand(CommandExecutionCallbackHandler handler, String ... command) {
        return this.sshHostSession.execute(handler, command);
    }

    @Override
    public InputStream get() throws RuntimeIOException {
        SshScpInputStream in = new SshScpInputStream(this);
        in.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opened SCP input stream from file " + this));
        }
        return in;
    }

    @Override
    public OutputStream put(long length) throws RuntimeIOException {
        SshScpOutputStream out = new SshScpOutputStream(this, length);
        out.open();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opened SCP output stream to file " + this));
        }
        return out;
    }

    private static class StatResults {
        public boolean exists;
        public boolean isDirectory;
        public long length = -1L;
        public boolean canRead;
        public boolean canWrite;
        public boolean canExecute;

        private StatResults() {
        }
    }
}

