/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.hostsession.LenientTemplateResolvingHostFileInputTransformer;
import com.xebialabs.deployit.steps.HostSessionStep;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyStep
extends HostSessionStep {
    private static final long MAX_FILE_SIZE = 0x100000L;
    protected String sourceLocation;
    protected String destinationLocation;
    protected Host destinationHost;
    protected Map<String, String> properties;
    private static Logger logger = Logger.getLogger(CopyStep.class);

    public CopyStep(Host sourceHost, String sourceLocation, Host destinationHost, String destinationLocation) {
        this(sourceHost, sourceLocation, destinationHost, destinationLocation, null);
    }

    public CopyStep(Host sourceHost, String sourceLocation, Host destinationHost, String destinationLocation, Map<String, String> properties) {
        super(sourceHost);
        if (StringUtils.isEmpty((String)sourceLocation)) {
            throw new ResolutionException("No source location specified");
        }
        if (StringUtils.isEmpty((String)destinationLocation)) {
            throw new ResolutionException("No destination location specified");
        }
        this.sourceLocation = sourceLocation;
        this.destinationLocation = destinationLocation;
        this.destinationHost = destinationHost;
        this.properties = properties;
        String description = "Copy " + sourceLocation + " from " + ExtendedStringUtils.getQuotedString(sourceHost.getLabel()) + " to " + destinationLocation + " on " + ExtendedStringUtils.getQuotedString(destinationHost.getLabel());
        if (this.properties != null) {
            description = description + " while replacing property values";
        }
        this.setDescription(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(StepExecutionContext ctx) {
        HostSession sourceSession = this.getHostSession();
        HostSession destinationSession = HostSessionFactory.getHostSession(this.destinationHost);
        try {
            HostFile sourceFile = sourceSession.getFile(this.sourceLocation);
            HostFile destinationFile = destinationSession.getFile(this.destinationLocation);
            if (this.properties != null) {
                HostFileUtils.copy(sourceFile, destinationFile, new LenientTemplateResolvingHostFileInputTransformer(this.properties));
            } else {
                HostFileUtils.copy(sourceFile, destinationFile);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            sourceSession.close();
            destinationSession.close();
        }
    }
}

