/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.ci.artifact.mapping;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.ConfigurationFiles;
import com.xebialabs.deployit.ci.artifact.mapping.DeployableArtifactMapping;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfigurationItem(description="A mapping of a ConfigurationFiles CI to a Host")
public class ConfigurationFilesMapping
extends DeployableArtifactMapping<ConfigurationFiles, Host> {
    public static final String TARGET_DIRECTORY_KEY_NAME = "TARGET_DIRECTORY";
    @ConfigurationItemProperty(required=true, description="The directory on the target host to which the configuration is to be copied. Non-existent directories on the path will be created. Example: /data/petclinic/1.0/conf")
    private String targetDirectory;
    @ConfigurationItemProperty(required=false, description="The target directory is shared when another resources using it as well.")
    private boolean shared;
    private static Logger logger = Logger.getLogger(ConfigurationFilesMapping.class);

    public ConfigurationFilesMapping() {
    }

    public ConfigurationFilesMapping(ConfigurationFiles source, Host target, String targetDirectory) {
        super(source, target);
        this.targetDirectory = targetDirectory;
    }

    @Override
    public List<KeyValuePair> getKeyValuePairs() {
        ArrayList kvps = Lists.newArrayList(super.getKeyValuePairs());
        Object existingTargetDirectoryKvp = CollectionUtils.find((Collection)kvps, (Predicate)new Predicate(){

            public boolean evaluate(Object each) {
                return ((KeyValuePair)each).getKey().equals(ConfigurationFilesMapping.TARGET_DIRECTORY_KEY_NAME);
            }
        });
        if (existingTargetDirectoryKvp == null) {
            kvps.add(new KeyValuePair(TARGET_DIRECTORY_KEY_NAME, this.getTargetDirectory()));
        } else {
            logger.warn((Object)("ConfigurationFilesMapping " + this + " already contains a key/value pair for key " + TARGET_DIRECTORY_KEY_NAME + ". Not overriding it."));
        }
        return kvps;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }
}

