/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;

@SuppressWarnings("serial")
public class CheckFileExistenceStep implements Step {

	protected final Host host;

	protected final String filePath;

	protected final boolean mustBeReadable;

	protected final boolean mustBeWritable;

	protected final boolean mustBeExecutable;

	public CheckFileExistenceStep(Host host, String filePath, boolean mustBeReadable, boolean mustBeWritable, boolean mustBeExecutable) {
		this.host = host;
		this.filePath = filePath;
		this.mustBeReadable = mustBeReadable;
		this.mustBeWritable = mustBeWritable;
		this.mustBeExecutable = mustBeExecutable;
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession rhs = host.getHostSession();
		try {
			HostFile f = rhs.getFile(filePath);
			if (!f.exists()) {
				ctx.logError("File " + filePath + " does not exist on host " + host);
				return false;
			} else {
				ctx.logOutput("File " + filePath + " exists on host " + host);
			}

			if (f.isDirectory()) {
				ctx.logError("File " + filePath + " on host " + host + " is a directory");
				return false;
			} else {
				ctx.logOutput("File " + filePath + " on host " + host + " is a regular file");
			}

			if (mustBeReadable) {
				if (!f.canRead()) {
					ctx.logError("File " + filePath + " on host " + host + " is not readable");
					return false;
				} else {
					ctx.logOutput("File " + filePath + " on host " + host + " is readable");
				}
			}

			if (mustBeWritable) {
				if (!f.canWrite()) {
					ctx.logError("File " + filePath + " on host " + host + " is not writable");
					return false;
				} else {
					ctx.logOutput("File " + filePath + " on host " + host + " is writable");
				}
			}

			//don't check executability for windows as there is no way to find out whether a file is executable or not.
			if (!f.canExecute()) {
				ctx.logError("File " + filePath + " on host " + host + " is not executable");
				return false;
			} else {
				ctx.logOutput("File " + filePath + " on host " + host + " is executable");
			}

			ctx.logOutput("Check for existence and permissions of file " + filePath + " on host " + host + " has succeeded");
			return true;
		} finally {
			rhs.close();
		}
	}

	public String getDescription() {
		return "Check existence and permissions of file " + filePath + " on host " + host;
	}

}
