/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.cifs;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CommandExecution;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.cifs.CifsHostFile;
import com.xebialabs.deployit.hostsession.common.AbstractHostSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import jcifs.smb.SmbFile;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CifsTelnetHostSession
extends AbstractHostSession
implements HostSession {
    private String address;
    private String username;
    private String password;
    private static final String DETECTABLE_WINDOWS_PROMPT = "WINDOWS4DEPLOYIT ";
    private static final String ERRORLEVEL_PREAMBLE = "ERRORLEVEL-PREAMBLE";
    private static final String ERRORLEVEL_POSTAMBLE = "ERRORLEVEL-POSTAMBLE";
    public static final int EXITCODE_CANNOT_DETERMINE_ERRORLEVEL = -999999;
    private static Logger logger = Logger.getLogger(CifsTelnetHostSession.class);

    public CifsTelnetHostSession(OperatingSystemFamily osFamily, String temporaryDirectoryPath, String address, int port, String username, String password) {
        super(osFamily, temporaryDirectoryPath);
        this.address = address;
        this.username = username;
        this.password = password;
    }

    @Override
    public int execute(CommandExecutionCallbackHandler handler, String ... commandLine) throws RuntimeIOException {
        return this.execute(handler, Collections.EMPTY_MAP, commandLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(CommandExecutionCallbackHandler handler, Map<String, String> inputResponse, String ... commandLine) {
        String command = CifsTelnetHostSession.encodeCommandLine(false, commandLine);
        String commandWithHiddenPassword = CifsTelnetHostSession.encodeCommandLine(true, commandLine);
        try {
            TelnetClient tc = new TelnetClient();
            tc.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(299, 25, true, false, true, false));
            tc.connect(this.address);
            try {
                InputStream stdout = tc.getInputStream();
                OutputStream stdin = tc.getOutputStream();
                StringBuffer outputBuf = new StringBuffer();
                this.waitFor(handler, stdout, outputBuf, "ogin:");
                this.send(handler, stdin, this.username);
                this.waitFor(handler, stdout, outputBuf, "assword:");
                this.send(handler, stdin, this.password);
                this.waitFor(handler, stdout, outputBuf, ">", "ogon failure");
                this.send(handler, stdin, "PROMPT WINDOWS4DEPLOYIT ");
                this.waitFor(handler, stdout, outputBuf, DETECTABLE_WINDOWS_PROMPT);
                this.waitFor(handler, stdout, outputBuf, DETECTABLE_WINDOWS_PROMPT);
                this.send(handler, stdin, command);
                this.waitFor(handler, stdout, outputBuf, DETECTABLE_WINDOWS_PROMPT);
                this.send(handler, stdin, "ECHO \"ERRORLEVEL-PREAMBLE%errorlevel%ERRORLEVEL-POSTAMBLE");
                this.waitFor(handler, stdout, outputBuf, ERRORLEVEL_POSTAMBLE);
                this.waitFor(handler, stdout, outputBuf, ERRORLEVEL_POSTAMBLE);
                int preamblePos = outputBuf.indexOf(ERRORLEVEL_PREAMBLE);
                int postamblePos = outputBuf.indexOf(ERRORLEVEL_POSTAMBLE);
                if (preamblePos >= 0 && postamblePos >= 0) {
                    String errorlevelString = outputBuf.substring(preamblePos + ERRORLEVEL_PREAMBLE.length(), postamblePos);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Errorlevel string found: " + errorlevelString));
                    }
                    try {
                        int n = Integer.parseInt(errorlevelString);
                        return n;
                    }
                    catch (NumberFormatException exc) {
                        logger.error((Object)("Cannot parse errorlevel in Windows output: " + outputBuf));
                        int n = -999999;
                        tc.disconnect();
                        return n;
                    }
                }
                logger.error((Object)("Cannot find errorlevel in Windows output: " + outputBuf));
                int n = -999999;
                return n;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                tc.disconnect();
            }
        }
        catch (InvalidTelnetOptionException exc) {
            throw new RuntimeIOException("Cannot execute command " + commandWithHiddenPassword + " on " + this.address, exc);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + commandWithHiddenPassword + " on " + this.address, exc);
        }
    }

    private void waitFor(CommandExecutionCallbackHandler handler, InputStream stdout, StringBuffer outputBuf, String expectedString) throws IOException {
        this.waitFor(handler, stdout, outputBuf, expectedString, null);
    }

    private void waitFor(CommandExecutionCallbackHandler handler, InputStream stdout, StringBuffer outputBuf, String expectedString, String unexpectedString) throws IOException {
        String s;
        boolean lastCharWasCr = false;
        boolean lastCharWasEsc = false;
        do {
            int c;
            if ((c = stdout.read()) == -1) {
                throw new IOException("End of stream reached");
            }
            handler.handleOutput((char)c);
            switch ((char)c) {
                case '\r': {
                    handler.handleOutputLine(outputBuf.toString());
                    outputBuf.delete(0, outputBuf.length());
                    break;
                }
                case '\n': {
                    if (lastCharWasCr) break;
                    handler.handleOutputLine(outputBuf.toString());
                    outputBuf.delete(0, outputBuf.length());
                    break;
                }
                case '[': {
                    if (lastCharWasEsc) {
                        throw new RuntimeIOException("VT100/ANSI escape sequence found in output stream. Please configure the Windows Telnet server to use stream mode (cmd: tlntadmn config mode=stream).");
                    }
                }
                default: {
                    outputBuf.append((char)c);
                }
            }
            lastCharWasCr = c == 13;
            boolean bl = lastCharWasEsc = c == 27;
            if (unexpectedString == null || outputBuf.length() < unexpectedString.length() || !(s = outputBuf.substring(outputBuf.length() - unexpectedString.length(), outputBuf.length())).equals(unexpectedString)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unexpected string \"" + unexpectedString + "\" found in Windows Telnet output"));
            }
            throw new IOException("Unexpected string \"" + unexpectedString + "\" found in Windows Telnet output");
        } while (outputBuf.length() < expectedString.length() || !(s = outputBuf.substring(outputBuf.length() - expectedString.length(), outputBuf.length())).equals(expectedString));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expected string \"" + expectedString + "\" found in Windows Telnet output"));
        }
    }

    private void send(CommandExecutionCallbackHandler handler, OutputStream stdin, String lineToSend) throws IOException {
        byte[] bytesToSend = (lineToSend + "\r\n").getBytes();
        stdin.write(bytesToSend);
        stdin.flush();
    }

    @Override
    public CommandExecution startExecute(String ... commandLine) {
        return null;
    }

    @Override
    public HostFile getFile(String hostPath) throws RuntimeIOException {
        try {
            SmbFile smbFile = new SmbFile(this.encodeAsSmbUrl(hostPath));
            return new CifsHostFile(this, smbFile);
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    @Override
    public HostFile getFile(HostFile parent, String child) throws RuntimeIOException {
        return this.getFile(parent.getPath() + this.getHostOperatingSystem().getFileSeparator() + child.replace('\\', '/'));
    }

    @Override
    public HostFile getTempFile(String prefix, String suffix) throws RuntimeIOException {
        Preconditions.checkNotNull((Object)prefix);
        if (suffix == null) {
            suffix = ".tmp";
        }
        Random r = new Random();
        String infix = "";
        int i = 0;
        while ((long)i < 100L) {
            HostFile f = this.getFile(this.getTemporaryDirectory().getPath() + this.getHostOperatingSystem().getFileSeparator() + prefix + infix + suffix);
            if (!f.exists()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created temporary file " + f));
                }
                return f;
            }
            infix = "-" + Long.toString(Math.abs(r.nextLong()));
            ++i;
        }
        throw new RuntimeIOException("Cannot generate a unique temporary file name on " + this);
    }

    private String encodeAsSmbUrl(String hostPath) {
        StringBuffer smbUrl = new StringBuffer();
        smbUrl.append("smb://");
        smbUrl.append(CifsTelnetHostSession.urlEncode(this.username.replaceFirst("\\\\", ";")));
        smbUrl.append(":");
        smbUrl.append(CifsTelnetHostSession.urlEncode(this.password));
        smbUrl.append("@");
        smbUrl.append(CifsTelnetHostSession.urlEncode(this.address));
        smbUrl.append("/");
        if (hostPath.length() < 2) {
            throw new RuntimeIOException("Host path \"" + hostPath + "\" is too short");
        }
        if (hostPath.charAt(1) != ':') {
            throw new RuntimeIOException("Host path \"" + hostPath + "\" does not have a colon (:) as its second character");
        }
        smbUrl.append(hostPath.charAt(0));
        smbUrl.append("$/");
        if (hostPath.length() >= 3) {
            if (hostPath.charAt(2) != '\\') {
                throw new RuntimeIOException("Host path \"" + hostPath + "\" does not have a backslash (\\) as its third character");
            }
            smbUrl.append(hostPath.substring(3).replace('\\', '/'));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Encoded Windows host path \"" + hostPath + "\" to SMB URL \"" + smbUrl.toString() + "\""));
        }
        return smbUrl.toString();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException("Unable to construct SMB URL", e);
        }
    }

    private static String encodeCommandLine(boolean hidePassword, String ... commandLine) {
        if (commandLine == null || commandLine.length == 0) {
            throw new IllegalStateException("Cannot execute an empty command line");
        }
        StringBuilder sb = new StringBuilder();
        boolean passwordKeywordSeen = false;
        for (int i = 0; i < commandLine.length; ++i) {
            int j;
            if (i != 0) {
                sb.append(' ');
            }
            if (commandLine[i] == null) {
                sb.append("null");
                continue;
            }
            if (commandLine[i].length() == 0) {
                sb.append("\" \"");
                continue;
            }
            if (passwordKeywordSeen && hidePassword) {
                for (j = 0; j < commandLine[i].length(); ++j) {
                    sb.append("*");
                }
            } else if (commandLine[i].indexOf(32) != -1) {
                sb.append("\"");
                for (j = 0; j < commandLine[i].length(); ++j) {
                    char c = commandLine[i].charAt(j);
                    if (c == '\"') {
                        sb.append('\"');
                    }
                    sb.append(c);
                }
                sb.append("\"");
            } else {
                sb.append(commandLine[i]);
            }
            passwordKeywordSeen = StringUtils.endsWithIgnoreCase((String)commandLine[i], (String)"password");
        }
        return sb.toString();
    }

    public String toString() {
        return this.username + "@" + this.address;
    }
}

