/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.hostsession.common;

import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileInputStreamTransformer;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.common.HostFileCopier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHostFile
implements HostFile {
    protected HostSession session;
    private static Logger logger = LoggerFactory.getLogger(AbstractHostFile.class);

    public AbstractHostFile(HostSession session) {
        this.session = session;
    }

    @Override
    public HostSession getSession() {
        return this.session;
    }

    @Override
    public HostFile getFile(String name) {
        return this.getSession().getFile(this, name);
    }

    @Override
    public HostFile getParentFile() {
        String parent = this.getParent();
        if (parent == null || parent.length() == 0) {
            return null;
        }
        return this.getSession().getFile(parent);
    }

    @Override
    public List<HostFile> listFiles() throws RuntimeIOException {
        List<String> filenames = this.list();
        if (filenames == null) {
            return null;
        }
        ArrayList<HostFile> listFiles = new ArrayList<HostFile>(filenames.size());
        for (String filename : filenames) {
            listFiles.add(this.getSession().getFile(this, filename));
        }
        return listFiles;
    }

    @Override
    public boolean deleteRecursively() throws RuntimeIOException {
        if (!this.exists()) {
            return false;
        }
        AbstractHostFile.deleteRecursivelyWithoutExistenceCheck(this);
        return true;
    }

    private static void deleteRecursivelyWithoutExistenceCheck(HostFile d) throws RuntimeIOException {
        if (d.isDirectory()) {
            List<HostFile> contents = d.listFiles();
            for (HostFile f : contents) {
                AbstractHostFile.deleteRecursivelyWithoutExistenceCheck(f);
            }
        }
        d.delete();
    }

    @Override
    public void copyFrom(HostFile srcHostFile, HostFileInputStreamTransformer transformer) throws RuntimeIOException {
        HostFileCopier.copy(srcHostFile, this, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(OutputStream out) throws RuntimeIOException {
        try {
            InputStream in = this.get();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void get(File file) throws RuntimeIOException {
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                this.get(out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(InputStream in, long length) throws RuntimeIOException {
        try {
            OutputStream out = this.put(length);
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(File file) throws RuntimeIOException {
        try {
            FileInputStream in = new FileInputStream(file);
            try {
                this.put(in, file.length());
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Resource resource) throws RuntimeIOException {
        try {
            byte[] resourceBytes = IOUtils.toByteArray((InputStream)resource.getInputStream());
            OutputStream out = this.put(resourceBytes.length);
            try {
                IOUtils.write((byte[])resourceBytes, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected StatResults executeStat() throws RuntimeIOException {
        StatResults results = new StatResults();
        CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
        int errno = this.executeCommand(capturedOutput, "ls", "-ld", this.getPath());
        if (errno == 0) {
            results.exists = true;
            if (capturedOutput.getOutputLines().size() > 0) {
                StringTokenizer outputTokens;
                String outputLine = capturedOutput.getOutputLines().get(0);
                if (logger.isDebugEnabled()) {
                    logger.debug("ls output = " + outputLine);
                }
                if ((outputTokens = new StringTokenizer(outputLine)).countTokens() < 5) {
                    throw new RuntimeIOException("ls -ld " + this.getPath() + " returned output that contains less than the expected 5 tokens");
                }
                String permissions = outputTokens.nextToken();
                String inodelinkes = outputTokens.nextToken();
                String owner = outputTokens.nextToken();
                String group = outputTokens.nextToken();
                String size = outputTokens.nextToken();
                results.isDirectory = permissions.length() >= 1 && permissions.charAt(0) == 'd';
                results.canRead = permissions.length() >= 2 && permissions.charAt(1) == 'r';
                results.canWrite = permissions.length() >= 3 && permissions.charAt(2) == 'w';
                results.canExecute = permissions.length() >= 4 && permissions.charAt(3) == 'x';
                try {
                    results.length = Integer.parseInt(size);
                }
                catch (NumberFormatException ignore) {}
            }
        } else {
            results.exists = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Statted file " + this + " (exists=" + results.exists + ", isDirectory=" + results.isDirectory + ", length=" + results.length + ", canRead=" + results.canRead + ", canWrite=" + results.canWrite + ", canExecute=" + results.canExecute + ")");
        }
        return results;
    }

    protected abstract int executeCommand(CommandExecutionCallbackHandler var1, String ... var2);

    protected static class StatResults {
        public boolean exists;
        public boolean isDirectory;
        public long length = -1L;
        public boolean canRead;
        public boolean canWrite;
        public boolean canExecute;

        protected StatResults() {
        }
    }
}

