package com.xebialabs.deployit.steps;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;

/**
 * This step will always pause the currently executing task. It needs to be marked skip in order for the task
 * to be able to continue after this step.
 */
public class PauseStep implements Step {
    public String getDescription() {
        return "This step will pause the task, it needs to be skipped to continue.";
    }

    public boolean execute(StepExecutionContext ctx) {
        ctx.logOutput("Pausing the task.");
        return false;
    }
}
