/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.ci.artifact;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Represents a {@link Folder} containing SQL files.
 * They are sorted using natural path order.
 */
@SuppressWarnings("serial")
@ConfigurationItem(description = "Folder in the Application Package containing sql files. Might contain sub folders")
public class SqlFolder extends Folder {

	@ConfigurationItemProperty(required = false, description = "Default is .sql")
	private String filter = ".sql";

     @ConfigurationItemProperty(description = "Placeholders found after scanning the artifact")
	private Set<String> placeholders = Sets.newHashSet();

	public Set<String> getPlaceholders() {
    	return placeholders;
    }

	public void setPlaceholders(Set<String> placeholders) {
    	this.placeholders = placeholders;
    }

	private transient final FilenameFilter sqlFilenameFilter = new FilenameFilter() {
		public boolean accept(File file, String name) {
			return name.toLowerCase().endsWith(filter);
		}
	};

	private transient final FilenameFilter directoryOnly = new FilenameFilter() {
		public boolean accept(java.io.File dir, String name) {
			return new File(dir, name).isDirectory();
		}
	};


	/**
	 * Return all the files, recursively
	 *
	 * @return
	 */
	@Override
	public List<File> getFiles() {
		List<File> allfiles = getSqlFiles(new File(getLocation()));
		Collections.sort(allfiles);
		return allfiles;
	}

	private List<File> getSqlFiles(File folder) {
		List<File> allfiles = Lists.newArrayList(folder.listFiles(sqlFilenameFilter));
		for (File file : folder.listFiles(directoryOnly)) {
			allfiles.addAll(getSqlFiles(file));
		}
		return allfiles;
	}
}