package com.xebialabs.deployit.tck.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.util.ClassUtils;

public abstract class ComponentClassScanner<T> extends ClassPathScanningCandidateComponentProvider {

	public ComponentClassScanner() {
		super(false);
	}

	@SuppressWarnings("unchecked")
	public final Collection<Class<? extends T>> getComponentClasses(String basePackage) {
		basePackage = basePackage == null ? "" : basePackage;
		List<Class<? extends T>> classes = new ArrayList<Class<? extends T>>();
		for (BeanDefinition candidate : findCandidateComponents(basePackage)) {
			try {
				Class<? extends T> cls = ClassUtils.resolveClassName(candidate.getBeanClassName(), ClassUtils.getDefaultClassLoader());
				classes.add((Class<? extends T>) cls);
			} catch (Throwable ex) {
				ex.printStackTrace();
			}
		}
		return classes;
	}

}