/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.tck.manifest;

import com.xebia.ad.plugin.PluginLoader;
import com.xebia.ad.repository.ConfigurationItemTypeDescriptorRepository;
import com.xebialabs.deployit.tck.manifest.ConfigurationItemScanner;
import com.xebialabs.deployit.tck.manifest.RunBookScanner;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.junit.Assert;

public class ManifestTester {
    public static void testManifest(String basePackage) {
        PluginLoader pluginLoader = new PluginLoader();
        pluginLoader.repository = new ConfigurationItemTypeDescriptorRepository();
        pluginLoader.loadPluginsWithoutDisabling();
        if (!pluginLoader.getLoadingErrors().isEmpty()) {
            for (String each : pluginLoader.getLoadingErrors()) {
                System.err.println("Plugin loader error: " + each);
            }
        }
        Assert.assertTrue((String)"Expected plugin loader to not have any loading errors", (boolean)pluginLoader.getLoadingErrors().isEmpty());
        ManifestTester.testConfigurationItemsAreMentionedInManifest(basePackage, pluginLoader);
        ManifestTester.testRunBooksAreMentionedInManifest(basePackage, pluginLoader);
    }

    private static void testConfigurationItemsAreMentionedInManifest(String basePackage, PluginLoader pluginLoader) {
        Collection ciTypesLoadedByPluginLoader = pluginLoader.getConfigurationItemTypes();
        ConfigurationItemScanner scanner = new ConfigurationItemScanner();
        Collection ciClasses = scanner.getComponentClasses(basePackage);
        for (Class eachCiClass : ciClasses) {
            Assert.assertTrue((String)("Expected configuration item " + eachCiClass.getName() + " to be mentioned in a MANIFEST.MF"), (boolean)ciTypesLoadedByPluginLoader.contains(eachCiClass));
            System.out.println("Found configuration item " + eachCiClass.getName() + " in a MANIFEST.MF");
        }
    }

    private static void testRunBooksAreMentionedInManifest(String basePackage, PluginLoader pluginLoader) {
        Collection runBooksLoadedByPluginLoader = pluginLoader.getRunBooks();
        RunBookScanner scanner = new RunBookScanner();
        Collection runBookClasses = scanner.getComponentClasses(basePackage);
        for (final Class eachRunBookClass : runBookClasses) {
            boolean x = CollectionUtils.exists((Collection)runBooksLoadedByPluginLoader, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    return arg0.getClass() == eachRunBookClass;
                }
            });
            Assert.assertTrue((String)("Expected run book " + eachRunBookClass.getName() + " to be mentioned in a MANIFEST.MF"), (boolean)x);
            System.out.println("Found run book " + eachRunBookClass.getName() + " in a MANIFEST.MF");
        }
    }
}

