/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.apache.httpd.ci;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ConfigurationItemProperty;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.HttpdServer;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.apache.httpd.ci.ApacheModule;
import com.xebialabs.deployit.plugin.apache.httpd.step.ApacheVirtualHostDefinition;
import java.util.Collections;
import java.util.Set;

@ConfigurationItem(description="An Apache 2 web server.", category="middleware")
public class ApacheHttpdServer
extends HttpdServer {
    @ConfigurationItemProperty(required=true, label="Path to apachectl", description="Path of the executable that will restart apache, e.g. /usr/sbin/apachectl")
    private String apachectlPath;
    @ConfigurationItemProperty(required=true, description="Location where deployit will generate apache httpd.conf fragment files.")
    private String configurationLocation;
    @ConfigurationItemProperty(required=true, label="Htdocs path", description="Location where deployit will create a directory (based on the vhost name) where static content will be placed.")
    private String htdocsLocation;
    @ConfigurationItemProperty(required=true, description="Location where deployit will create a directory where access log will be placed.")
    private String accessLogLocation;
    @ConfigurationItemProperty(required=true, description="Location where deployit will create a directory where error log will be placed.")
    private String errorLogLocation;
    @ConfigurationItemProperty(asContainment=true)
    private Set<ApacheModule> modules = Sets.newHashSet();

    public HostSession connectToAdminHost() {
        return HostSessionFactory.getHostSession((Host)this.host);
    }

    public ApacheVirtualHostDefinition getVhostDefinition(String virtualHost) {
        return new ApacheVirtualHostDefinition(virtualHost, this.htdocsLocation, this.host.getOperatingSystemFamily(), Collections.singleton(this));
    }

    public String getConfFilePathForVirtualHost(String virtualHost) {
        StringBuilder confFilePath = new StringBuilder();
        confFilePath.append(this.getConfigurationLocation());
        confFilePath.append(this.getHost().getFileSeparator());
        confFilePath.append(this.getVhostDefinition(virtualHost).getFileName());
        return confFilePath.toString();
    }

    public String getHtdocsDirPathForVirtualHost(String virtualHost) {
        return this.getVhostDefinition(virtualHost).getDocumentRoot();
    }

    public String getApachectlPath() {
        return this.apachectlPath;
    }

    public void setApachectlPath(String apachectlPath) {
        this.apachectlPath = apachectlPath;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    public String getHtdocsLocation() {
        return this.htdocsLocation;
    }

    public void setHtdocsLocation(String htdocsLocation) {
        this.htdocsLocation = htdocsLocation;
    }

    public String getAccessLogLocation() {
        return this.accessLogLocation;
    }

    public void setAccessLogLocation(String accessLogLocation) {
        this.accessLogLocation = accessLogLocation;
    }

    public String getErrorLogLocation() {
        return this.errorLogLocation;
    }

    public void setErrorLogLocation(String errorLogLocation) {
        this.errorLogLocation = errorLogLocation;
    }

    public void addModule(ApacheModule module) {
        if (this.modules == null) {
            this.modules = Sets.newHashSet();
        }
        this.modules.add(module);
    }

    public ApacheModule getModule(Class<? extends ApacheModule> moduleclass) {
        Set apacheModuleSet = Sets.filter(this.modules, (Predicate)new PredicateModuleByClass(moduleclass));
        if (!apacheModuleSet.isEmpty()) {
            return (ApacheModule)((Object)apacheModuleSet.iterator().next());
        }
        throw new ResolutionException("No module of type " + moduleclass + " in " + this.modules);
    }

    public boolean isSupportedModule(Class<? extends ApacheModule> moduleclass) {
        return !Sets.filter(this.modules, (Predicate)new PredicateModuleByClass(moduleclass)).isEmpty();
    }

    public Set<ApacheModule> getModules() {
        return this.modules;
    }

    public void setModules(Set<ApacheModule> modules) {
        this.modules = modules;
    }

    private static class PredicateModuleByClass
    implements Predicate<ApacheModule> {
        final Class<? extends ApacheModule> moduleClass;

        public PredicateModuleByClass(Class<? extends ApacheModule> moduleClass) {
            this.moduleClass = moduleClass;
        }

        public boolean apply(ApacheModule input) {
            if (input == null) {
                return false;
            }
            return ((Object)((Object)input)).getClass().isAssignableFrom(this.moduleClass);
        }
    }
}

