package com.xebialabs.deployit.plugin.steps

import com.xebialabs.deployit.plugin.api.flow._
import com.xebialabs.deployit.plugin.api.rules._
import com.xebialabs.overthere.OverthereFile

@StepMetadata(name = "delete")
class DeleteStep extends BaseStep with TargetHostSupport {

  @StepParameter(description = "Path of the file or folder to be deleted")
  private val targetPath: String = ""

  @RulePostConstruct
  def doPostConstruct(ctx: StepPostConstructContext): Unit = {

    calculateTargetHost(ctx)
    calculateOrder(ctx)

    if ((description == null || description.isEmpty) && targetHost != null) {
      description = s"Deleting $targetPath from ${targetHost.getName}"
    }
  }

  override protected[steps] def executeOnTargetHost(implicit ctx: ExecutionContext, targetHostEnvironment: HostEnvironment): StepExitCode = {
    val file: OverthereFile = remoteFile(targetPath)
    if (file.exists) {
      ctx.logOutput(s"Deleting $targetPath from ${targetHost.getName}")
      file.deleteRecursively()
    } else {
      ctx.logOutput(s"Target $targetPath does not exist, nothing to delete.")
    }
    StepExitCode.SUCCESS
  }
}
