package com.xebialabs.deployit.plugin.freemarker

import freemarker.ext.beans.BeansWrapper
import freemarker.template.Configuration
import grizzled.slf4j.Logging


object ConfigurationHolder extends Logging {
  def configuration(maskPasswords: Boolean = false): Configuration = {
    configuration(new BaseCiAwareObjectWrapper(maskPasswords))
  }

  def configuration(wrapper: BeansWrapper): Configuration = {
    val conf = new Configuration()
    conf.setNumberFormat("computer")
    conf.setTemplateLoader(new ClasspathTemplateLoader())
    conf.setObjectWrapper(wrapper)
    conf
  }
}
