package com.xebialabs.deployit.plugin.freemarker.sanitizer

import freemarker.template.TemplateMethodModelEx

class WindowsScriptSanitizer extends TemplateMethodModelEx {
  private val SLASH_ESCAPE: String = "\\[]\".*?"
  private val CARET_ESCAPE: String = "'`,;=()!|<>&^"
  val CR: Char = '\r'

  def exec(arguments: java.util.List[_]): String = {
    if (arguments == null || arguments.size() != 1 || arguments.get(0) == null)
      throw new IllegalArgumentException("Invalid arguments provided for sanitize expression")

    val value: String = arguments.get(0).toString
    if (value == null || value.isEmpty || value.equals("********"))
      return value
    value.toList.flatMap(x => {
      x match {
        case CR => List[Char]('^', x)
        case '%' => List[Char]('%', x)
        case _ => {
          if (SLASH_ESCAPE.contains(x)) {
            List[Char]('\\', x)
          }
          else if (CARET_ESCAPE.contains(x)) {
            List[Char]('^', x)
          } else {
            List[Char](x)
          }
        }
      }
    }).mkString
  }
}
