package com.xebialabs.deployit.plugin.freemarker.sanitizer

import freemarker.template.TemplateMethodModelEx

class UnixScriptSanitizer extends TemplateMethodModelEx {

  private val UNIX_SHELL_CHARS: String = "\"';{}()&$\\|*?><"
  private val WS_CHARS: String = "\n\r\t"
  val CR: Char = '\r'
  val LF: Char = '\n'
  val TAB: Char = '\t'

  def exec(arguments: java.util.List[_]): String = {
    if (arguments == null || arguments.size() != 1 || arguments.get(0) == null)
      throw new IllegalArgumentException("Invalid arguments provided for sanitize expression")
    val value: String = arguments.get(0).toString
    if (value == null || value.isEmpty || value.equals("********"))
      return value
    value.toList.flatMap(x => {
      if (UNIX_SHELL_CHARS.contains(x)) {
        List[Char]('\\', x)
      }
      else if (WS_CHARS.contains(x)) {
        List[Char]('\\', x, x match {
          case CR => 'r'
          case LF => 'n'
          case TAB => 't'
        })
      }
      else List[Char](x)
    }).mkString
  }
}
