/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.lb.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Collection;

public class Predicates2 {
    public static Predicate<Type> subtypeOfAny(Type ... types) {
        return new IsSubtypeOfAny(types);
    }

    public static Predicate<ConfigurationItem> instanceOfAny(Type ... types) {
        return Predicates.compose(Predicates2.subtypeOfAny(types), (Function)new Function<ConfigurationItem, Type>(){

            public Type apply(ConfigurationItem input) {
                return input.getType();
            }
        });
    }

    public static Predicate<ConfigurationItem> instanceOf(Type type) {
        return Predicates2.instanceOfAny(type);
    }

    public static Predicate<Delta> operationIn(Operation ... operationsToMatch) {
        return new OperationIn(operationsToMatch);
    }

    public static Predicate<Delta> operationIs(Operation operationToMatch) {
        return Predicates2.operationIn(operationToMatch);
    }

    private static class IsSubtypeOfAny
    implements Predicate<Type> {
        private final Collection<Type> subtypes;

        public IsSubtypeOfAny(Type ... typesToMatch) {
            ImmutableSet.Builder subtypes = ImmutableSet.builder();
            for (Type typeToMatch : typesToMatch) {
                subtypes.addAll((Iterable)DescriptorRegistry.getSubtypes((Type)typeToMatch));
                subtypes.add((Object)typeToMatch);
            }
            this.subtypes = subtypes.build();
        }

        public boolean apply(Type input) {
            return this.subtypes.contains(input);
        }
    }

    private static class OperationIn
    implements Predicate<Delta> {
        private final Collection<Operation> operationsToMatch;

        protected OperationIn(Operation ... operationsToMatch) {
            this.operationsToMatch = ImmutableSet.copyOf((Object[])operationsToMatch);
        }

        public boolean apply(Delta input) {
            return this.operationsToMatch.contains(input.getOperation());
        }
    }
}

