package com.xebialabs.deployit.plugin.cloud.step;

import java.util.HashMap;
import java.util.List;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.step.rule.NullCheck;
import com.xebialabs.deployit.plugin.cloud.step.rule.ResultCheck;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;

@SuppressWarnings("serial")
public class ValidateDescriptorStep implements Step {

    private InstanceDescriptorResolver descriptorResolver;
    private CiParser ciParser;
    private String descriptorTemplate;
    private HashMap<Object,Object> scope;

    private ResultCheck resultCheck;

    public ValidateDescriptorStep(final InstanceDescriptorResolver descriptorResolver, CiParser ciParser, HashMap<Object,Object> scope, String descriptorTemplate) {
        this(descriptorResolver, ciParser, scope, descriptorTemplate, new NullCheck());
    }

    public ValidateDescriptorStep(final InstanceDescriptorResolver descriptorResolver, CiParser ciParser, HashMap<Object,Object> scope, String descriptorTemplate, final ResultCheck resultCheck) {
        this.descriptorResolver = descriptorResolver;
        this.ciParser = ciParser;
        this.descriptorTemplate = descriptorTemplate;
        this.scope = scope;
        this.resultCheck = resultCheck;
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public String getDescription() {
        return "Validate XML descriptor";
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {

        String descriptor;

        try {
            descriptor = descriptorResolver.resolve(descriptorTemplate, scope);
            ctx.logOutput("Successfully processed descriptor template...");
            ctx.logOutput("-------------------------------------------");
            ctx.logOutput(descriptor);
            ctx.logOutput("-------------------------------------------");
        } catch (Exception e) {
            ctx.logError("Can not process descriptor template.");
            ctx.logError(e.getMessage());
            return StepExitCode.FAIL;
        }

        try {
            List<ConfigurationItem> cis = ciParser.fromString(descriptor, ctx.getRepository());
            ctx.logOutput("Successfully parsed " + cis.size() + " CIs");
            resultCheck.check(cis);
            return StepExitCode.SUCCESS;
        } catch (ResultCheck.Failed e) {
            ctx.logError("Resulted CIs don't meet expectation: " + e.getMessage());
            return StepExitCode.FAIL;
        } catch (Exception e) {
            ctx.logError("Can not parse generated XML. " + e.getMessage());
            return StepExitCode.FAIL;
        }

    }
}
