/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.ci;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.ConnectionType;
import com.xebialabs.deployit.plugin.cloud.validation.MarkerFileValidation;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.util.List;
import java.util.concurrent.TimeoutException;

@Metadata(description="Base class for instance templates, all instance templates must extend it")
@MarkerFileValidation
public abstract class BaseHostTemplate
extends BaseConfigurationItem {
    @Property(required=true, size=Property.Size.LARGE, label="Instance descriptor", description="Freemarker template of XML which describes instance and middleware")
    private String xmlDescriptor;
    @Property(required=false, category="Marker", label="OS family")
    private OperatingSystemFamily os;
    @Property(required=false, category="Marker", label="Connection type", description="Connection type to be used for connecting to the host")
    private ConnectionType connectionType;
    @Property(required=false, category="Marker", label="Username")
    private String username;
    @Property(required=false, category="Marker", label="Password", password=true)
    private String password;
    @Property(required=false, category="Marker", label="Private key file to use for authentication")
    private String privateKeyFile;
    @Property(required=false, category="Marker", label="Path to the marker file", description="Path to the file which should appear on the instance when provisioning completes.")
    private String markerPath;
    @Property(required=true, defaultValue="500", label="Boot timeout", description="Maximal amount of time (in seconds) allowed to elapse before the instance is ready.")
    private int bootTimeout;
    @Property(required=false, defaultValue="5", category="Marker", label="Retry delay", description="Delay (in seconds) after each connection attempt.")
    private int retryDelay;

    public String getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    public void setXmlDescriptor(String xmlDescriptor) {
        this.xmlDescriptor = xmlDescriptor;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public void setMarkerPath(String markerPath) {
        this.markerPath = markerPath;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public OperatingSystemFamily getOs() {
        return this.os;
    }

    public void setOs(OperatingSystemFamily os) {
        this.os = os;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getMarkerPath() {
        return this.markerPath;
    }

    public int getBootTimeout() {
        return this.bootTimeout;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public abstract List<? extends Step> produceCreateSteps(String var1, int var2);

    public abstract List<? extends Step> produceDestroySteps(ConfigurationItem var1);

    public abstract String getInstanceIpAddress(String var1) throws TimeoutException;
}

