package com.xebialabs.deployit.plugin.cloud.step.plan;

import java.util.Collection;
import com.google.common.base.Predicate;

import com.xebialabs.deployit.plugin.api.flow.Step;

import static com.google.common.collect.Collections2.filter;

public class SingleStepFilter implements Predicate<Step> {

    private final Collection<? extends Step> presentSteps;

    public SingleStepFilter(final Collection<? extends Step> presentSteps) {
        this.presentSteps = presentSteps;
    }

    @Override
    public boolean apply(final Step s) {
        if (s.getClass().isAnnotationPresent(Unique.class)) {
            return presentSteps == null || filter(presentSteps, new Predicate<Step>() {
                @Override
                public boolean apply(final Step input) {
                    return input.getClass().equals(s.getClass());
                }
            }).isEmpty();
        }

        return true;
    }
}
