package com.xebialabs.deployit.plugin.cloud.step.plan;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import com.google.common.base.Predicate;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.collect.Collections2.filter;
import static java.util.Arrays.asList;

/**
 * The aim of this filter is to filter away those steps which are annotated with {@link Unique}, and who's type is already present at {@link #presentSteps} for particular {@link #type}.
 */
public class SingleStepFilter implements Predicate<Step> {

    private final Map<Type, Collection<? extends Step>> presentSteps;

    private final Type type;

    public SingleStepFilter(final Map<Type, Collection<? extends Step>> presentSteps, final Type type) {
        this.presentSteps = presentSteps;
        this.type = checkNotNull(type);
    }

    @Override
    public boolean apply(final Step s) {
        Collection<? extends Step> stepsForType = presentSteps.get(type);

        if (stepsForType == null || !s.getClass().isAnnotationPresent(Unique.class)) {
            return true;
        }

        for (Step step : stepsForType) {
            if (step.getClass().equals(s.getClass())) {
                return false;
            }
        }

        return true;
    }
}
