/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cmd.whitelist.validator;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.core.serialization.JsonSerialization;
import com.xebialabs.deployit.plugin.cmd.whitelist.exception.CommandWhitelistException;
import com.xebialabs.deployit.plugin.cmd.whitelist.model.CommandWhitelist;
import com.xebialabs.deployit.plugin.cmd.whitelist.model.RoleRule;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.JSONConfiguration;
import org.apache.commons.configuration2.builder.ReloadingFileBasedConfigurationBuilder;
import org.apache.commons.configuration2.ex.ConfigurationException;

public class CommandWhitelistValidator {
    private ReloadingFileBasedConfigurationBuilder<JSONConfiguration> reloadingCommandWhitelistConfig;
    private RoleService roleService;

    public CommandWhitelistValidator(ReloadingFileBasedConfigurationBuilder<JSONConfiguration> reloadingCommandWhitelistConfig, RoleService roleService) {
        this.reloadingCommandWhitelistConfig = reloadingCommandWhitelistConfig;
        this.roleService = roleService;
    }

    public void validate(String user, String cmd) throws IOException {
        CommandWhitelist whitelist = this.getRules();
        if (whitelist == null) {
            return;
        }
        if (whitelist.isEnabled()) {
            List<String> allAllowed = whitelist.getAllUsersRule().getAllowedCommands();
            List<String> allRestricted = whitelist.getAllUsersRule().getRestrictedCommands();
            this.validateCommandsForAllUsers(allAllowed, allRestricted, cmd);
            List userRoles = this.roleService.getRolesFor(user);
            for (Role userRole : userRoles) {
                if (!whitelist.getRoles().stream().anyMatch(role -> role.getRoleName().equals(userRole.getName()))) continue;
                RoleRule roleRule = whitelist.getRoles().stream().filter(role -> role.getRoleName().equals(userRole.getName())).findFirst().orElse(new RoleRule());
                this.validateCommandsForCurrentUser(roleRule, cmd);
                allAllowed.addAll(roleRule.getAllowedCommands());
                allRestricted.addAll(roleRule.getRestrictedCommands());
            }
            this.validateWhitelisted(allAllowed, allRestricted, cmd);
        }
    }

    private void validateWhitelisted(List<String> allAllowed, List<String> allRestricted, String cmd) {
        if (!allAllowed.isEmpty() && !allRestricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified. Please set only one of those properties.");
        }
        if (!allAllowed.isEmpty() && allAllowed.stream().noneMatch(regex -> Pattern.matches(regex, cmd))) {
            throw new CommandWhitelistException("Command " + cmd + " is not whitelisted in allowed-commands.");
        }
    }

    private void validateCommandsForCurrentUser(RoleRule roleRule, String cmd) {
        String roleName = roleRule.getRoleName();
        List<String> allowed = roleRule.getAllowedCommands();
        List<String> restricted = roleRule.getRestrictedCommands();
        if (!allowed.isEmpty() && !restricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified for role " + roleName + ". Please set only one of those properties.");
        }
        if (!restricted.isEmpty()) {
            restricted.forEach(regex -> {
                if (Pattern.matches(regex, cmd)) {
                    throw new CommandWhitelistException("Command " + cmd + " is restricted for role " + roleName + " by rule " + regex);
                }
            });
        }
    }

    private void validateCommandsForAllUsers(List<String> allowed, List<String> restricted, String cmd) {
        if (!allowed.isEmpty() && !restricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified for all users. Please set only one of those properties.");
        }
        if (!restricted.isEmpty()) {
            restricted.forEach(regex -> {
                if (Pattern.matches(regex, cmd)) {
                    throw new CommandWhitelistException("Command " + cmd + " is restricted by rule " + regex + " for all users.");
                }
            });
        }
    }

    private CommandWhitelist getRules() throws IOException {
        String content;
        try {
            JSONConfiguration conf = (JSONConfiguration)this.reloadingCommandWhitelistConfig.getConfiguration();
            StringWriter writer = new StringWriter();
            conf.write((Writer)writer);
            content = writer.toString();
        }
        catch (ConfigurationException e) {
            throw new CommandWhitelistException("Unable to load the command validation configuration at conf/command-whitelist.json. Check if file exists and is properly formatted.");
        }
        ObjectMapper objectMapper = JsonSerialization.mapper();
        objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return (CommandWhitelist)objectMapper.readValue(content, CommandWhitelist.class);
    }
}

