/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cmd.whitelist.validator;

import com.xebialabs.deployit.core.config.CommandWhitelistConfiguration;
import com.xebialabs.deployit.core.config.Roles;
import com.xebialabs.deployit.plugin.cmd.whitelist.exception.CommandWhitelistException;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CommandWhitelistValidator {
    private final CommandWhitelistConfiguration commandWhitelistConfiguration;
    private final RoleService roleService;

    public CommandWhitelistValidator(CommandWhitelistConfiguration commandWhitelistConfiguration, RoleService roleService) {
        this.commandWhitelistConfiguration = commandWhitelistConfiguration;
        this.roleService = roleService;
    }

    public void validate(String user, String cmd) throws IOException {
        if (this.commandWhitelistConfiguration == null) {
            return;
        }
        if (this.commandWhitelistConfiguration.enabled()) {
            ArrayList<String> allAllowed = new ArrayList<String>(this.commandWhitelistConfiguration.allUsers().allowedCommands());
            ArrayList<String> allRestricted = new ArrayList<String>(this.commandWhitelistConfiguration.allUsers().restrictedCommands());
            this.validateCommandsForAllUsers(allAllowed, allRestricted, cmd);
            List userRoles = this.roleService.getRolesFor(user);
            for (Role userRole : userRoles) {
                if (!this.commandWhitelistConfiguration.roles().stream().anyMatch(role -> role.roleName().equals(userRole.getName()))) continue;
                Roles roleRule = this.commandWhitelistConfiguration.roles().stream().filter(role -> role.roleName().equals(userRole.getName())).findFirst().orElse(new Roles());
                this.validateCommandsForCurrentUser(roleRule, cmd);
                allAllowed.addAll(roleRule.allowedCommands());
                allRestricted.addAll(roleRule.restrictedCommands());
            }
            this.validateWhitelisted(allAllowed, allRestricted, cmd);
        }
    }

    private void validateWhitelisted(List<String> allAllowed, List<String> allRestricted, String cmd) {
        if (!allAllowed.isEmpty() && !allRestricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified. Please set only one of those properties.");
        }
        if (!allAllowed.isEmpty() && allAllowed.stream().noneMatch(regex -> Pattern.matches(regex, cmd))) {
            throw new CommandWhitelistException("Command " + cmd + " is not whitelisted in allowed-commands.");
        }
    }

    private void validateCommandsForCurrentUser(Roles roleRule, String cmd) {
        String roleName = roleRule.roleName();
        List allowed = roleRule.allowedCommands();
        List restricted = roleRule.restrictedCommands();
        if (!allowed.isEmpty() && !restricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified for role " + roleName + ". Please set only one of those properties.");
        }
        if (!restricted.isEmpty()) {
            restricted.forEach(regex -> {
                if (Pattern.matches(regex, cmd)) {
                    throw new CommandWhitelistException("Command " + cmd + " is restricted for role " + roleName + " by rule " + regex);
                }
            });
        }
    }

    private void validateCommandsForAllUsers(List<String> allowed, List<String> restricted, String cmd) {
        if (!allowed.isEmpty() && !restricted.isEmpty()) {
            throw new CommandWhitelistException("Both allowed commands and restricted commands specified for all users. Please set only one of those properties.");
        }
        if (!restricted.isEmpty()) {
            restricted.forEach(regex -> {
                if (Pattern.matches(regex, cmd)) {
                    throw new CommandWhitelistException("Command " + cmd + " is restricted by rule " + regex + " for all users.");
                }
            });
        }
    }
}

