package com.xebialabs.deployit.plugin.cmd.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.cmd.ci.Command;
import com.xebialabs.deployit.plugin.cmd.step.ExecuteCommandStep;
import com.xebialabs.deployit.plugin.cmd.step.NoCommandStep;
import com.xebialabs.deployit.plugin.file.File;
import com.xebialabs.deployit.plugin.overthere.Host;

import java.util.Set;

@SuppressWarnings("serial")
@Metadata(description = "Command deployed to a Host")
public class DeployedCommand extends BaseDeployed<Command, Host> {

    @Property(description = "Order of the command", defaultValue = "50")
    private int order = 50;

    @Property(required = false, description = "Artifacts that the command depends on")
    private Set<File> dependencies;

    @Property(description = "Command line to execute on host. Dependent artifacts can be referred to using ${artifact name}.",
            required = false, size = Property.Size.LARGE)
    private String commandLine;

    @Property(required = false, description = "Command to execute when undeploying command")
    private Command undoCommand;

    @Property(required = false, description = "Indicates whether the undoCommand should be run on an upgrade")
    private boolean runUndoCommandOnUpgrade = true;

    @Property(required = false, isTransient = true, description = "Forces the command to be rerun.")
    private boolean rerunCommand;

    @Create
    public void executeCreateCommand(DeploymentPlanningContext ctx) {
        ctx.addStep(new ExecuteCommandStep(order, this));
    }

    @Modify
    public void executeModifyCommand(DeploymentPlanningContext ctx) {
        if (undoCommand != null && runUndoCommandOnUpgrade) {
            DeployedCommand deployedUndoCommand = createDeployedUndoCommand();
            ctx.addStep(new ExecuteCommandStep(undoCommand.getOrder(), deployedUndoCommand));
        }

        ctx.addStep(new ExecuteCommandStep(order, this));
    }

    private DeployedCommand createDeployedUndoCommand() {
        DeployedCommand deployedUndoCommand = new DeployedCommand();
        deployedUndoCommand.setCommandLine(undoCommand.getCommandLine());
        deployedUndoCommand.setDependencies(undoCommand.getDependencies());
        deployedUndoCommand.setOrder(undoCommand.getOrder());
        deployedUndoCommand.setContainer(getContainer());
        deployedUndoCommand.setDeployable(undoCommand);
        deployedUndoCommand.setId(undoCommand.getId());
        deployedUndoCommand.setSyntheticProperties(getSyntheticProperties());
        return deployedUndoCommand;
    }


    @Destroy
    public void destroyCommand(DeploymentPlanningContext ctx) {
        if (undoCommand != null) {
            DeployedCommand deployedUndoCommand = createDeployedUndoCommand();
            ctx.addStep(new ExecuteCommandStep(undoCommand.getOrder(), deployedUndoCommand));
        } else {
            ctx.addStep(new NoCommandStep(order, this));
        }
    }

    public Set<File> getDependencies() {
        return dependencies;
    }

    public void setDependencies(Set<File> dependencies) {
        this.dependencies = dependencies;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getCommandLine() {
        return commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public Command getUndoCommand() {
        return undoCommand;
    }

    public void setUndoCommand(Command undoCommand) {
        this.undoCommand = undoCommand;
    }

    public boolean isRunUndoCommandOnUpgrade() {
        return runUndoCommandOnUpgrade;
    }

    public void setRunUndoCommandOnUpgrade(boolean runUndoCommandOnUpgrade) {
        this.runUndoCommandOnUpgrade = runUndoCommandOnUpgrade;
    }

    public boolean isRerunCommand() {
        return rerunCommand;
    }

    public void setRerunCommand(boolean rerunCommand) {
        this.rerunCommand = rerunCommand;
    }
}
