@echo off
setlocal

<#import "/sql/commonFunctions.ftl" as cmn>
<#include "/generic/templates/windowsSetEnvVars.ftl">

echo BEGIN TRANSACTION; > wrapper.sql
type ${step.uploadedArtifactPath} >> wrapper.sql
echo COMMIT TRANSACTION; >> wrapper.sql

<#assign commandOpts='-b -S ${deployed.container.serverName}' />

<#if cmn.lookup('username')?? && cmn.lookup('password')??>
  <#assign commandOpts="${commandOpts} -U ${cmn.lookup('username')} -P ${cmn.lookup('password')}" />
</#if>

<#if (deployed.container.databaseName?has_content) >
  <#assign commandOpts="${commandOpts} -d ${deployed.container.databaseName}" />
</#if>

<#if (deployed.container.additionalOptions?has_content) >
  <#assign commandOpts="${commandOpts} ${deployed.container.additionalOptions}" />
</#if>

sqlcmd ${commandOpts} -i wrapper.sql

set RES=%ERRORLEVEL%
if not %RES% == 0 (
  exit %RES%
)

endlocal
