#!/bin/sh

<#include "/generic/templates/linuxExportEnvVars.ftl">
<#import "/sql/commonFunctions.ftl" as cmn>

DB2_COMMAND="${deployed.container.db2Home}/bin/db2"

<#if !cmn.lookup('username')??>
$DB2_COMMAND CONNECT TO ${sanitize(deployed.container.databaseName)}
<#else>
  <#if !cmn.lookup('password')??>
$DB2_COMMAND CONNECT TO ${sanitize(deployed.container.databaseName)} USER ${sanitize(cmn.lookup('username'))}
  <#else>
$DB2_COMMAND CONNECT TO ${sanitize(deployed.container.databaseName)} USER ${sanitize(cmn.lookup('username'))} USING ${sanitize(cmn.lookup('password'))}
  </#if>
</#if>
res=$?
if [ $res -ge 4 ] ; then
        exit $res
fi

cd "${cmn.scriptsPath()}"
$DB2_COMMAND ${cmn.lookup('additionalOptions')!} -vf "${sqlScriptToExecute}"
res=$?
if [ $res -ge 4 ] ; then
        exit $res
fi

$DB2_COMMAND DISCONNECT ${sanitize(deployed.container.databaseName)}
res=$?
if [ $res -ge 4 ] ; then
        exit $res
fi
