package com.xebialabs.deployit.plugins.releaseauth.step;

import static java.lang.String.format;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.Version;

@SuppressWarnings("serial")
public class LogReleaseConditionsStep implements DeploymentStep {
	private final Set<String> conditions;
	private Version deploymentPackage;
	private final int order;

	public LogReleaseConditionsStep(int order, Set<String> conditions,
	                                Version deploymentPackage) {
		this.conditions = conditions;
		this.deploymentPackage = deploymentPackage;
		this.order = order;
	}

	@Override
	public Result execute(DeploymentExecutionContext ctx) throws Exception {
        ctx.logOutput(" release conditions:");
        ctx.logOutput(buildValidatedConditionsMessage(conditions));
		return Result.Success;
	}

	private static String buildValidatedConditionsMessage(Set<String> validatedConditions) {
        StringBuilder message = new StringBuilder();
        for (String conditionName : validatedConditions) {
        	message.append(format("Condition '%s': OK%n", conditionName));
        }
		return message.toString();
	}

	@Override
	public String getDescription() {
		return format("Logging release authorization for deployment of '%s'", deploymentPackage);
	}
	
	@Override
	public int getOrder() {
		return order;
	}
}
