/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionVerifier {
    private static final Descriptor DEPLOYMENT_PACKAGE_DESCRIPTOR = DescriptorRegistry.getDescriptor((Type)Type.valueOf(DeploymentPackage.class));
    private static final Logger logger = LoggerFactory.getLogger(ConditionVerifier.class);

    public static VerificationResult validateReleaseConditions(Set<String> set, Version version) {
        VerificationResult verificationResult = new VerificationResult();
        block4: for (String string : set) {
            String string2;
            if (!version.hasProperty(string)) {
                string2 = string.replaceFirst("satisfies", "requires");
                throw new RuntimeException(String.format("Property '%s' is missing from the definition of udm.DeploymentPackage. It is required since udm.Environment has a corresponding property named '%s'", string, string2));
            }
            string2 = DEPLOYMENT_PACKAGE_DESCRIPTOR.getPropertyDescriptor(string).getKind();
            Object object = version.getProperty(string);
            logger.debug("condition value for condition {} is {}", (Object)string, object);
            switch (1.$SwitchMap$com$xebialabs$deployit$plugin$api$reflect$PropertyKind[string2.ordinal()]) {
                case 1: {
                    ConditionVerifier.verifyBooleanCondition(string, (Boolean)object, verificationResult);
                    continue block4;
                }
                case 2: {
                    ConditionVerifier.verifyStringCondition(string, (String)object, verificationResult);
                    continue block4;
                }
            }
            throw new IllegalArgumentException(String.format("Only release conditions of kind '%s' or '%s' are supported, but condition '%s' was of kind '%s'", PropertyKind.BOOLEAN, PropertyKind.STRING, string2));
        }
        return verificationResult;
    }

    private static void verifyBooleanCondition(String string, Boolean bl, VerificationResult verificationResult) {
        if (!Boolean.TRUE.equals(bl)) {
            verificationResult.logViolatedCondition(string, Boolean.TRUE, bl);
        } else {
            verificationResult.logValidatedCondition(string);
        }
    }

    private static void verifyStringCondition(String string, String string2, VerificationResult verificationResult) {
        if (ConditionVerifier.isNullOrBlank(string2)) {
            verificationResult.logViolatedCondition(string, "non-empty value", string2);
        } else {
            verificationResult.logValidatedCondition(string);
        }
    }

    private static boolean isNullOrBlank(String string) {
        return Strings.nullToEmpty((String)string).trim().isEmpty();
    }

    public static class ViolatedCondition<T> {
        public final String name;
        public final T expectedValue;
        public final T actualValue;

        private ViolatedCondition(String string, T t, T t2) {
            this.name = string;
            this.expectedValue = t;
            this.actualValue = t2;
        }
    }

    public static class VerificationResult {
        private final ImmutableSet.Builder<ViolatedCondition<?>> violatedConditions = new ImmutableSet.Builder();
        private final ImmutableSet.Builder<String> validatedConditions = new ImmutableSet.Builder();
        private boolean failed = false;

        private <T> void logViolatedCondition(String string, T t, T t2) {
            this.violatedConditions.add(new ViolatedCondition(string, t, t2));
            this.failed = true;
        }

        private void logValidatedCondition(String string) {
            this.validatedConditions.add((Object)string);
        }

        public boolean failed() {
            return this.failed;
        }

        public Set<ViolatedCondition<?>> getViolatedConditions() {
            return this.violatedConditions.build();
        }

        public Set<String> getValidatedConditions() {
            return this.validatedConditions.build();
        }
    }
}

