/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.planning;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugins.releaseauth.ConditionVerifier;
import com.xebialabs.deployit.plugins.releaseauth.step.LogReleaseConditionsStep;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckReleaseConditionsAreMet {
    public static final String ENV_RELEASE_CONDITIONS_PROPERTY = "releaseConditions";
    private static final String ENV_RECHECK_CONDITIONS_PROPERTY = "recheckConditionsAtDeploymentTime";
    private static final String ENV_RECHECK_CONDITIONS_ORDER_PROPERTY = "recheckConditionsAtDeploymentTimeOrder";
    private static final String RELEASE_CHECKLIST_CATEGORY_NAME = "Deployment Checklist";
    private static final List<DeploymentStep> NO_STEPS = ImmutableList.of();
    private static final Logger logger = LoggerFactory.getLogger(CheckReleaseConditionsAreMet.class);

    @PrePlanProcessor
    public static List<DeploymentStep> validate(DeltaSpecification deltaSpecification) {
        DeployedApplication deployedApplication = deltaSpecification.getDeployedApplication();
        Set<String> set = CheckReleaseConditionsAreMet.getReleaseConditions(deployedApplication);
        if (set.isEmpty()) {
            return NO_STEPS;
        }
        ConditionVerifier.VerificationResult verificationResult = ConditionVerifier.validateReleaseConditions(set, deployedApplication.getVersion());
        if (verificationResult.failed()) {
            throw new IllegalArgumentException(CheckReleaseConditionsAreMet.buildErrorMessage(deployedApplication, verificationResult.getViolatedConditions()));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        Environment environment = deployedApplication.getEnvironment();
        if (!environment.hasProperty(ENV_RECHECK_CONDITIONS_PROPERTY) || Boolean.TRUE.equals(environment.getProperty(ENV_RECHECK_CONDITIONS_PROPERTY))) {
            int n = environment.hasProperty(ENV_RECHECK_CONDITIONS_ORDER_PROPERTY) ? (Integer)environment.getProperty(ENV_RECHECK_CONDITIONS_ORDER_PROPERTY) : 0;
            logger.debug("Adding release auth condition check step at order {}", (Object)n);
            builder.add((Object)new LogReleaseConditionsStep(n, set, deployedApplication.getVersion()));
        }
        return builder.build();
    }

    private static Set<String> getReleaseConditions(DeployedApplication deployedApplication) {
        final Environment environment = deployedApplication.getEnvironment();
        Collection collection = Collections2.filter((Collection)environment.getType().getDescriptor().getPropertyDescriptors(), (Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor propertyDescriptor) {
                Object object = propertyDescriptor.get((ConfigurationItem)environment);
                if (propertyDescriptor.getCategory().equals(CheckReleaseConditionsAreMet.RELEASE_CHECKLIST_CATEGORY_NAME) && !propertyDescriptor.getName().startsWith("requires")) {
                    logger.warn(String.format("Ignoring property '%s' as a release condition for environment '%s' as it does not start with the keyword 'requires'", propertyDescriptor.getName(), environment.getName()));
                    return false;
                }
                return propertyDescriptor.getCategory().equals(CheckReleaseConditionsAreMet.RELEASE_CHECKLIST_CATEGORY_NAME) && object != null && (Boolean)object != false;
            }
        });
        Collection collection2 = Collections2.transform((Collection)collection, (Function)new Function<PropertyDescriptor, String>(){

            public String apply(PropertyDescriptor propertyDescriptor) {
                return propertyDescriptor.getName().replaceFirst("requires", "satisfies");
            }
        });
        return new HashSet<String>(collection2);
    }

    private static String buildErrorMessage(DeployedApplication deployedApplication, Set<ConditionVerifier.ViolatedCondition<?>> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot deploy '").append(deployedApplication.getName()).append("' (version ").append(deployedApplication.getVersion().getVersion()).append(") to '").append(deployedApplication.getEnvironment().getName()).append("' as the following release conditions are not met:");
        for (ConditionVerifier.ViolatedCondition<?> violatedCondition : set) {
            stringBuilder.append("\n- '").append(violatedCondition.name).append("'");
        }
        return stringBuilder.toString();
    }
}

