/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugins.releaseauth.ReleaseCondition;
import java.util.Set;

public class LogReleaseConditionsStep
implements DeploymentStep {
    private final Set<ReleaseCondition> conditions;
    private Version deploymentPackage;
    private final int order;

    public LogReleaseConditionsStep(int order, Set<ReleaseCondition> conditions, Version deploymentPackage) {
        this.conditions = conditions;
        this.deploymentPackage = deploymentPackage;
        this.order = order;
    }

    public Step.Result execute(DeploymentExecutionContext ctx) throws Exception {
        ctx.logOutput(" release conditions:");
        ctx.logOutput(this.buildValidatedConditionsMessage());
        return Step.Result.Success;
    }

    private String buildValidatedConditionsMessage() {
        StringBuilder message = new StringBuilder();
        for (ReleaseCondition condition : this.conditions) {
            message.append(String.format("Condition '%s': OK%n", condition));
        }
        return message.toString();
    }

    public String getDescription() {
        return String.format("Logging release authorization for deployment of '%s'", this.deploymentPackage);
    }

    public int getOrder() {
        return this.order;
    }
}

