package com.xebialabs.deployit.plugins.releaseauth.verification;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.EnumSet;

import com.xebialabs.deployit.plugin.api.reflect.*;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Verify(clazz = SatisfiesPropertyVerification.Verification.class, type = "satisfiesProperties")
public @interface SatisfiesPropertyVerification {

    public static class Verification implements TypeVerification {
        @Override
        public void verify(final Descriptor descriptor, final VerificationContext context) {
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                String propName = propertyDescriptor.getName();
                if (propName.startsWith("satisfies") && !isSatisfiesKind(propertyDescriptor)) {
                    context.error("Property [%s] satisfies a release condition but is not of type boolean or string.", propName);
                }

                if (propName.startsWith("satisfies")) {
                    PropertyDescriptor rolesProp = descriptor.getPropertyDescriptor("roles" + propName.substring("satisfies".length()));
                    if (rolesProp != null && rolesProp.getKind() != PropertyKind.SET_OF_STRING) {
                        context.error("Property [%s] defines the allowed roles for a release condition but is not of type list of string", rolesProp.getName());
                    }
                }
            }
        }

        private boolean isSatisfiesKind(final PropertyDescriptor propertyDescriptor) {
            return EnumSet.of(PropertyKind.BOOLEAN, PropertyKind.STRING).contains(propertyDescriptor.getKind());
        }
    }
}
