/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.xld.DistributionVersion;
import com.xebialabs.deployit.plugins.releaseauth.ReleaseCondition;
import java.util.Set;

public class LogReleaseConditionsStep
implements Step {
    private final Set<ReleaseCondition> conditions;
    private DistributionVersion deploymentPackage;
    private final int order;

    public LogReleaseConditionsStep(int order, Set<ReleaseCondition> conditions, DistributionVersion deploymentPackage) {
        this.conditions = conditions;
        this.deploymentPackage = deploymentPackage;
        this.order = order;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput(" release conditions:");
        ctx.logOutput(this.buildValidatedConditionsMessage());
        return StepExitCode.SUCCESS;
    }

    private String buildValidatedConditionsMessage() {
        StringBuilder message = new StringBuilder();
        for (ReleaseCondition condition : this.conditions) {
            message.append(String.format("Condition '%s': OK%n", condition));
        }
        return message.toString();
    }

    public String getDescription() {
        return String.format("Logging release authorization for deployment of '%s'", this.deploymentPackage);
    }

    public int getOrder() {
        return this.order;
    }
}

