/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.upgrade;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit38DeploymentPipeline
extends JcrUpgrade {
    public static final String DEPLOYIT_NAMESPACE_PREFIX = "deployit";
    public static final String CONFIGURATION_ITEM_NODETYPE_NAME = "deployit:configurationItem";
    public static final String METADATA_PROPERTY_NAME_PREFIX = "$";
    public static final String CONFIGURATION_ITEM_TYPE_PROPERTY_NAME = "$configuration.item.type";
    private static final String CORE_DIRECTORY = "core.Directory";
    private static final String DEPLOYIT_37_DEPLOYMENT_PIPELINE_PROPERTY = "deploymentPipeline";
    private static final Logger logger = LoggerFactory.getLogger(Deployit38DeploymentPipeline.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.8 upgrade -- Externalize deployment pipeline ***");
        try {
            List<Type> applicationTypes = this.findAllApplicationSubtypes();
            List<Node> nodes = this.gatherNodes(repository, applicationTypes);
            Multimap<String, Node> directoryToApplications = this.divideApplicationsByDirectory(nodes);
            Deployit38DeploymentPipeline.createDirectories(repository, directoryToApplications.keySet());
            for (Node node : directoryToApplications.values()) {
                Deployit38DeploymentPipeline.convertPipelineForApplication(repository, node);
            }
            logger.info("*** Finished upgrade ***");
            return true;
        }
        catch (Exception e) {
            throw new UpgradeException("", e);
        }
    }

    private List<Type> findAllApplicationSubtypes() {
        ArrayList applicationTypes = Lists.newArrayList((Object[])new Type[]{Type.valueOf(Application.class)});
        applicationTypes.addAll(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Application.class)));
        logger.info("All application subtypes: " + applicationTypes);
        return applicationTypes;
    }

    private List<Node> gatherNodes(RawRepository repository, List<Type> subtypes) {
        ArrayList nodes = Lists.newArrayList();
        for (Type subtype : subtypes) {
            nodes.addAll(repository.findNodesByType(subtype));
        }
        return nodes;
    }

    private Multimap<String, Node> divideApplicationsByDirectory(List<Node> nodes) throws RepositoryException {
        TreeMultimap result = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                try {
                    return o1.getPath().compareTo(o2.getPath());
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        for (Node node : nodes) {
            result.put((Object)node.getParent().getPath(), (Object)node);
        }
        return result;
    }

    private static void convertPipelineForApplication(RawRepository repository, Node applicationNode) throws Exception {
        logger.debug("Found node [{}] that is a subtype of Application", (Object)applicationNode.getPath());
        if (applicationNode.hasProperty(DEPLOYIT_37_DEPLOYMENT_PIPELINE_PROPERTY)) {
            logger.debug("Node [{}] has a deploymentPipeline property", (Object)applicationNode.getPath());
            Node pipelineNode = Deployit38DeploymentPipeline.createPipelineNode(repository, applicationNode);
            Deployit38DeploymentPipeline.updateApplication(applicationNode, pipelineNode);
        } else {
            logger.debug("Node [{}] does not have a deploymentPipeline property", (Object)applicationNode.getPath());
        }
    }

    private static void updateApplication(Node applicationNode, Node pipelineNode) throws Exception {
        applicationNode.setProperty(DEPLOYIT_37_DEPLOYMENT_PIPELINE_PROPERTY, (String[])null);
        applicationNode.setProperty("pipeline", pipelineNode);
    }

    private static Node createPipelineNode(RawRepository repository, Node applicationNode) throws PathNotFoundException, RepositoryException {
        Property property = applicationNode.getProperty(DEPLOYIT_37_DEPLOYMENT_PIPELINE_PROPERTY);
        Value[] environments = property.getValues();
        Node pipelineNode = Deployit38DeploymentPipeline.createNode(repository, Deployit38DeploymentPipeline.applicationIdToConfigurationId(applicationNode) + "-pipeline", Type.valueOf((String)"release.DeploymentPipeline"));
        pipelineNode.setProperty("pipeline", environments);
        return pipelineNode;
    }

    private static void createDirectories(RawRepository repository, Set<String> nodes) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        TreeSet<String> s = Deployit38DeploymentPipeline.gatherAllIds(nodes);
        for (String node : s) {
            Node n = repository.read(node);
            if (!Deployit38DeploymentPipeline.isDirectory(n)) continue;
            Deployit38DeploymentPipeline.cloneNodeUnderConfigurationRoot(repository, n);
        }
    }

    protected static TreeSet<String> gatherAllIds(Set<String> nodes) {
        TreeSet toBeCreated = Sets.newTreeSet();
        for (String node : nodes) {
            Iterable split = Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)node);
            StringBuilder n = new StringBuilder();
            for (String s : split) {
                n.append("/").append(s);
                toBeCreated.add(n.toString());
            }
        }
        return toBeCreated;
    }

    private static boolean exists(RawRepository repository, String id) {
        try {
            repository.read(id);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void cloneNodeUnderConfigurationRoot(RawRepository repository, Node applicationDirectory) throws RepositoryException {
        String newId = Deployit38DeploymentPipeline.applicationIdToConfigurationId(applicationDirectory);
        logger.debug("Cloning node [{}] under root [{}] at id [{}]", new Object[]{applicationDirectory.getPath(), "Configuration", newId});
        if (!Deployit38DeploymentPipeline.exists(repository, newId)) {
            Node node = repository.create(newId);
            Deployit38DeploymentPipeline.cloneMixins(applicationDirectory, node);
            Deployit38DeploymentPipeline.cloneProperties(applicationDirectory, node);
        }
    }

    private static String applicationIdToConfigurationId(Node directory) throws RepositoryException {
        return "/Configuration" + directory.getPath().substring("/Applications".length());
    }

    private static void cloneProperties(Node src, Node dst) throws RepositoryException {
        PropertyIterator iterator = src.getProperties();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.getDefinition().isProtected()) continue;
            if (property.isMultiple()) {
                dst.setProperty(property.getName(), property.getValues(), property.getType());
                continue;
            }
            dst.setProperty(property.getName(), property.getValue(), property.getType());
        }
    }

    private static void cloneMixins(Node src, Node dst) throws RepositoryException {
        for (NodeType mixin : src.getMixinNodeTypes()) {
            dst.addMixin(mixin.getName());
        }
    }

    private static boolean isDirectory(Node node) throws ValueFormatException, RepositoryException, PathNotFoundException {
        return node.getProperty(CONFIGURATION_ITEM_TYPE_PROPERTY_NAME).getString().equals(CORE_DIRECTORY);
    }

    private static Node createNode(RawRepository repository, String id, Type type) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        Node node = repository.create(id);
        if (node.getIndex() != 1) {
            node.remove();
            throw new IllegalStateException("The impossible has happened, you already have a node called [" + id + "] in your repository. Please contact deployit-support@xebialabs.com");
        }
        node.addMixin(CONFIGURATION_ITEM_NODETYPE_NAME);
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
        node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        node.setProperty(CONFIGURATION_ITEM_TYPE_PROPERTY_NAME, type.toString());
        logger.debug("Created a [{}] at [{}]", (Object)CORE_DIRECTORY, (Object)id);
        return node;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployment-checklist-plugin", (String)"3.8.0");
    }
}

