/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;
import org.jclouds.rest.annotations.Identity;

public class BundleInstanceS3StorageOptions
extends BaseEC2RequestOptions {
    @Inject(optional=true)
    @Identity
    String currentAwsAccessKeyId;

    @Override
    public Multimap<String, String> buildFormParameters() {
        if (this.getAwsAccessKeyId() == null) {
            Preconditions.checkState(this.currentAwsAccessKeyId != null, "currentAwsAccessKeyId should have been injected");
            this.bucketOwnedBy(this.currentAwsAccessKeyId);
        }
        return super.buildFormParameters();
    }

    public BundleInstanceS3StorageOptions bucketOwnedBy(String ccessKeyId) {
        this.formParameters.put("Storage.S3.AWSAccessKeyId", Preconditions.checkNotNull(ccessKeyId, "ccessKeyId"));
        return this;
    }

    public String getAwsAccessKeyId() {
        return this.getFirstFormOrNull("Storage.S3.AWSAccessKeyId");
    }

    public static class Builder {
        public static BundleInstanceS3StorageOptions bucketOwnedBy(String ccessKeyId) {
            BundleInstanceS3StorageOptions options = new BundleInstanceS3StorageOptions();
            return options.bucketOwnedBy(ccessKeyId);
        }
    }
}

