/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.fromconfig;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.location.Iso3166;
import org.jclouds.location.suppliers.LocationIdToIso3166CodesSupplier;
import org.jclouds.util.Predicates2;

@Singleton
public class LocationIdToIso3166CodesFromConfiguration
implements LocationIdToIso3166CodesSupplier {
    private final Function<Predicate<String>, Map<String, String>> filterStringsBoundByName;

    @Inject
    public LocationIdToIso3166CodesFromConfiguration(Function<Predicate<String>, Map<String, String>> filterStringsBoundByName) {
        this.filterStringsBoundByName = Preconditions.checkNotNull(filterStringsBoundByName, "filterStringsBoundByName");
    }

    @Override
    @Singleton
    @Iso3166
    public Map<String, Supplier<Set<String>>> get() {
        Map<String, String> stringsBoundWithRegionOrZonePrefix = this.filterStringsBoundByName.apply(Predicates.or(Predicates2.startsWith("jclouds.region"), Predicates2.startsWith("jclouds.zone")));
        ImmutableMap.Builder<String, Supplier<ImmutableSet<String>>> codes = ImmutableMap.builder();
        for (String key : ImmutableSet.of("jclouds.region", "jclouds.zone")) {
            String regionOrZoneString = stringsBoundWithRegionOrZonePrefix.get(key + "s");
            if (regionOrZoneString == null) continue;
            for (String region : Splitter.on(',').split(regionOrZoneString)) {
                String isoCodes = stringsBoundWithRegionOrZonePrefix.get(key + "." + region + "." + "iso3166-codes");
                if (isoCodes == null) continue;
                codes.put(region, Suppliers.ofInstance(ImmutableSet.copyOf(Splitter.on(',').split(isoCodes))));
            }
        }
        return codes.build();
    }
}

