/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.concurrent.internal.SyncProxy;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;
import org.jclouds.util.Optionals2;

public class CreateClientForCaller
extends CacheLoader<ClassMethodArgs, Object> {
    @Inject
    Injector injector;
    private final LoadingCache<ClassMethodArgs, Object> asyncMap;
    private final Provider<LoadingCache<ClassMethodArgs, Object>> delegateMap;
    Map<Class<?>, Class<?>> sync2Async;

    @Inject
    CreateClientForCaller(@Named(value="async") LoadingCache<ClassMethodArgs, Object> asyncMap, @Named(value="sync") Provider<LoadingCache<ClassMethodArgs, Object>> delegateMap) {
        this.asyncMap = asyncMap;
        this.delegateMap = delegateMap;
    }

    @Override
    public Object load(ClassMethodArgs from) {
        Class<?> syncClass = Optionals2.returnTypeOrTypeOfOptional(from.getMethod());
        Class<?> asyncClass = this.sync2Async.get(syncClass);
        Preconditions.checkState(asyncClass != null, "configuration error, sync class " + syncClass + " not mapped to an async class");
        Object asyncClient = this.asyncMap.getUnchecked(from);
        Preconditions.checkState(asyncClient != null, "configuration error, sync client for " + from + " not found");
        Function<ClassMethodArgsAndReturnVal, Optional<Object>> optionalConverter = this.injector.getInstance(Key.get(new TypeLiteral<Function<ClassMethodArgsAndReturnVal, Optional<Object>>>(){}));
        Map<String, Long> timeoutsMap = this.injector.getInstance(Key.get(new TypeLiteral<Map<String, Long>>(){}, (Annotation)Names.named("TIMEOUTS")));
        try {
            return SyncProxy.proxy(optionalConverter, syncClass, asyncClient, this.delegateMap.get(), this.sync2Async, timeoutsMap);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }
}

