package com.xebialabs.deployit.plugin.ec2.ci;

import java.util.List;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.ec2.steps.ValidateCredentialsStep;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;

import static java.util.Arrays.asList;

/**
 * Reusable AWS EC2 credentials pair
 */
@SuppressWarnings("serial")
@Metadata(description = "Amazon EC2 credentials", root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Credentials extends BaseConfigurationItem {

    @Property(required = true, label = "AWS key")
    private String key;

    @Property(required = true, password = true, label = "AWS secret")
    private String secret;

    @ControlTask(label = "Validate credentials", description = "Make a test call to EC2 with given credentials")
    public List<Step> validateCredentials() {
        return asList(
                (Step) new ValidateCredentialsStep(this, new ServiceFactory())
        );
    }

    public String getKey() {
        return key;
    }

    public String getSecret() {
        return secret;
    }
}
