/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.implicit;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.location.functions.ToIdAndScope;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;

@Singleton
public class FirstRegion
implements ImplicitLocationSupplier {
    private final Supplier<Set<? extends Location>> locationsSupplier;

    @Inject
    FirstRegion(@Memoized Supplier<Set<? extends Location>> locationsSupplier) {
        this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplierSupplier");
    }

    @Override
    public Location get() {
        Set<? extends Location> locations = this.locationsSupplier.get();
        try {
            return Iterables.find(locations, LocationPredicates.isRegion());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("none to of the locations are scope REGION: " + Iterables.transform(locations, ToIdAndScope.INSTANCE));
        }
    }
}

