/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.net.URI;
import java.util.Comparator;
import java.util.Map;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadata;
import org.jclouds.javax.annotation.Nullable;

public abstract class ResourceMetadataImpl<T extends Enum<T>>
implements ResourceMetadata<T>,
Serializable {
    private static final long serialVersionUID = -280558162576368264L;
    @Nullable
    private final String providerId;
    @Nullable
    private final String name;
    @Nullable
    private final Location location;
    @Nullable
    private final URI uri;
    private final Map<String, String> userMetadata = Maps.newLinkedHashMap();

    public ResourceMetadataImpl(@Nullable String providerId, @Nullable String name, @Nullable Location location, @Nullable URI uri, Map<String, String> userMetadata) {
        this.providerId = providerId;
        this.name = name;
        this.location = location;
        this.uri = uri;
        this.userMetadata.putAll((Map)Preconditions.checkNotNull(userMetadata, (Object)"userMetadata"));
    }

    @Override
    public int compareTo(ResourceMetadata<T> that) {
        return ComparisonChain.start().compare((Object)this.getName(), (Object)that.getName(), (Comparator)Ordering.natural().nullsLast()).result();
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceMetadataImpl that = (ResourceMetadataImpl)ResourceMetadataImpl.class.cast(o);
        return Objects.equal(this.getType(), that.getType()) && Objects.equal((Object)this.providerId, (Object)that.providerId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.location, (Object)that.location) && Objects.equal((Object)this.uri, (Object)that.uri);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getType(), this.providerId, this.name, this.location, this.uri});
    }

    public String toString() {
        return this.string().toString();
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").omitNullValues().add("type", this.getType()).add("providerId", (Object)this.providerId).add("name", (Object)this.name).add("location", (Object)this.location).add("uri", (Object)this.uri).add("userMetadata", this.userMetadata);
    }
}

