/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.concurrent.internal.SyncProxy;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;
import org.jclouds.util.Optionals2;

public class CreateClientForCaller
extends CacheLoader<ClassMethodArgs, Object> {
    @Inject
    Injector injector;
    private final LoadingCache<ClassMethodArgs, Object> asyncMap;
    private final Provider<LoadingCache<ClassMethodArgs, Object>> delegateMap;
    Map<Class<?>, Class<?>> sync2Async;

    @Inject
    CreateClientForCaller(@Named(value="async") LoadingCache<ClassMethodArgs, Object> asyncMap, @Named(value="sync") Provider<LoadingCache<ClassMethodArgs, Object>> delegateMap) {
        this.asyncMap = asyncMap;
        this.delegateMap = delegateMap;
    }

    public Object load(ClassMethodArgs from) {
        Class<?> syncClass = Optionals2.returnTypeOrTypeOfOptional(from.getMethod());
        Class<?> asyncClass = this.sync2Async.get(syncClass);
        Preconditions.checkState((asyncClass != null ? 1 : 0) != 0, (Object)("configuration error, sync class " + syncClass + " not mapped to an async class"));
        Object asyncClient = this.asyncMap.getUnchecked((Object)from);
        Preconditions.checkState((asyncClient != null ? 1 : 0) != 0, (Object)("configuration error, sync client for " + from + " not found"));
        Function optionalConverter = (Function)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Function<ClassMethodArgsAndReturnVal, Optional<Object>>>(){}));
        Map timeoutsMap = (Map)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, Long>>(){}, (Annotation)Names.named((String)"TIMEOUTS")));
        try {
            return SyncProxy.proxy((Function<ClassMethodArgsAndReturnVal, Optional<Object>>)optionalConverter, syncClass, asyncClient, (LoadingCache<ClassMethodArgs, Object>)((LoadingCache)this.delegateMap.get()), this.sync2Async, timeoutsMap);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

