/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Maps2 {
    public static <K> Function<Map<K, ?>, Set<K>> keySetFunction() {
        return new Function<Map<K, ?>, Set<K>>(){

            public Set<K> apply(Map<K, ?> arg0) {
                return arg0.keySet();
            }

            public String toString() {
                return "keySet()";
            }
        };
    }

    public static <K, V> Map<K, V> convertUnsafe(Multimap<K, V> in) {
        LinkedHashMap out = Maps.newLinkedHashMap();
        for (Map.Entry entry : in.entries()) {
            out.put(entry.getKey(), entry.getValue());
        }
        return ImmutableMap.copyOf((Map)out);
    }

    public static <V> Map<String, V> renameKey(Map<String, V> in, String k1, String k2) {
        if (((Map)Preconditions.checkNotNull(in, (Object)"input map")).containsKey(Preconditions.checkNotNull((Object)k1, (Object)"old key"))) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.putAll(Maps.filterKeys(in, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)k1))));
            V tags = in.get(k1);
            builder.put(Preconditions.checkNotNull((Object)k2, (Object)"new key"), tags);
            in = builder.build();
        }
        return in;
    }

    public static <K1, K2, V> Map<K2, V> transformKeys(Map<K1, V> in, Function<K1, K2> fn) {
        Preconditions.checkNotNull(in, (Object)"input map");
        Preconditions.checkNotNull(fn, (Object)"function");
        ImmutableMap.Builder returnVal = ImmutableMap.builder();
        for (Map.Entry<K1, V> entry : in.entrySet()) {
            returnVal.put(fn.apply(entry.getKey()), entry.getValue());
        }
        return returnVal.build();
    }

    public static <K, V> Supplier<Map<K, V>> composeMapSupplier(Iterable<Supplier<Map<K, V>>> suppliers) {
        return new ListMapSupplier<K, V>(suppliers);
    }

    public static <K, V> Map<K, V> fromKeys(Set<K> keys, Function<? super K, V> valueFunction) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)keys.size());
        for (K key : keys) {
            result.put(Preconditions.checkNotNull(key), valueFunction.apply(key));
        }
        return result;
    }

    public static <K, V> ImmutableMap<K, V> uniqueIndex(Iterable<? extends V> values, Function<? super V, ? extends K> keyFunction) {
        return ImmutableMap.copyOf((Map)Maps.uniqueIndex(values, keyFunction));
    }

    static class ListMapSupplier<K, V>
    implements Supplier<Map<K, V>> {
        private final Iterable<Supplier<Map<K, V>>> suppliers;

        ListMapSupplier(Iterable<Supplier<Map<K, V>>> suppliers) {
            this.suppliers = (Iterable)Preconditions.checkNotNull(suppliers, (Object)"suppliers");
        }

        public Map<K, V> get() {
            LinkedHashMap toReturn = Maps.newLinkedHashMap();
            for (Supplier<Map<K, V>> supplier : this.suppliers) {
                toReturn.putAll((Map)supplier.get());
            }
            return toReturn;
        }
    }
}

