/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ExceptionParsingListenableFuture<T>
implements ListenableFuture<T> {
    private final ListenableFuture<T> future;
    private final Function<Exception, T> function;

    public static <T> ExceptionParsingListenableFuture<T> create(ListenableFuture<T> future, Function<Exception, T> function) {
        return new ExceptionParsingListenableFuture<T>(future, function);
    }

    public ExceptionParsingListenableFuture(ListenableFuture<T> future, Function<Exception, T> function) {
        this.future = (ListenableFuture)Preconditions.checkNotNull(future);
        this.function = (Function)Preconditions.checkNotNull(function);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public T get() throws InterruptedException, ExecutionException {
        try {
            return (T)this.future.get();
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            return this.attemptConvert(e);
        }
    }

    private T attemptConvert(Exception e) {
        if (e instanceof ExecutionException && e.getCause() instanceof Exception) {
            return (T)this.function.apply((Object)((Exception)e.getCause()));
        }
        return (T)this.function.apply((Object)e);
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (T)this.future.get(timeout, unit);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (TimeoutException te) {
            throw te;
        }
        catch (Exception e) {
            return this.attemptConvert(e);
        }
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public void addListener(Runnable listener, Executor exec) {
        this.future.addListener(listener, exec);
    }
}

