/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TagSetHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Map<String, String>> {
    private StringBuilder currentText = new StringBuilder();
    private ImmutableMap.Builder<String, String> result;
    private boolean inItem = false;
    private String key;
    private String value;

    public Map<String, String> getResult() {
        return this.result.build();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"tagSet")) {
            this.result = ImmutableMap.builder();
        } else if (qName.equals("item")) {
            this.inItem = true;
            this.key = null;
            this.value = null;
        }
        this.currentText = new StringBuilder();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("item")) {
            this.inItem = false;
            if (this.key != null) {
                this.result.put((Object)this.key, (Object)Strings.nullToEmpty((String)this.value));
            }
        }
        if (this.inItem) {
            if (qName.equals("key")) {
                this.key = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            } else if (qName.equals("value")) {
                this.value = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

