/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.filters;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;

@Singleton
public class BasicAuthentication
implements HttpRequestFilter {
    private final String header;

    @Inject
    public BasicAuthentication(@Identity String user, @Credential String password, Crypto crypto) {
        this.header = "Basic " + CryptoStreams.base64(String.format("%s:%s", Preconditions.checkNotNull((Object)user, (Object)"user"), Preconditions.checkNotNull((Object)password, (Object)"password")).getBytes());
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", this.header)).build();
    }
}

