/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.api.validation.Regex;
import com.xebialabs.deployit.plugin.generic.ci.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.step.InspectScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="Abstract deployed that can target any deployable to a generic container")
public abstract class AbstractDeployed<D extends Deployable>
extends BaseDeployed<D, HostContainer> {
    public static final String STEP_OPTION_NONE = "none";
    public static final String STEP_OPTION_UPLOAD_ARTIFACT_DATA = "uploadArtifactData";
    public static final String STEP_OPTION_UPLOAD_CLASSPATH_RESOURCES = "uploadClasspathResources";
    public static final String STEP_OPTION_UPLOAD_TEMPLATE_CLASSPATH_RESOURCES = "uploadTemplateClasspathResources";
    public static final String STEP_OPTIONS_DEFAULT = "uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources";
    public static final String STEP_OPTIONS_REGEX = "(none|uploadArtifactData|uploadClasspathResources|uploadTemplateClasspathResources)";
    public static final String STEP_OPTIONS_DESCRIPTION_SUFFIX = " (1 or more of: none,uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources).";
    private Map<String, Object> freeMarkerContext = Collections.singletonMap("deployed", this);
    private DeployedApplication deployedApplication;
    private Operation planOperation;
    @Property(defaultValue="false", hidden=true, description="The generic container requires a restart for the action performed by this deployed.", required=false)
    private boolean restartRequired;
    @Property(defaultValue="false", hidden=true, description="The generic container requires a restart for the NOOP action performed by this deployed.", required=false)
    private boolean restartRequiredForNoop;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the create operation.")
    private int createOrder;
    @Property(hidden=true, defaultValue="40", description="The order of the step in the step list for the destroy operation.")
    private int destroyOrder;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the modify operation.")
    private int modifyOrder;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the noop operation.")
    private int noopOrder;
    @Property(hidden=true, defaultValue="Create")
    private String createVerb;
    @Property(hidden=true, defaultValue="Modify")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="Destroy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="Modify")
    private String noopVerb;
    @Property(hidden=true, defaultValue="uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources", description="Options for the create step (1 or more of: none,uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|uploadTemplateClasspathResources)")
    private Set<String> createOptions;
    @Property(hidden=true, defaultValue="uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources", description="Options for the modify step (1 or more of: none,uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|uploadTemplateClasspathResources)")
    private Set<String> modifyOptions;
    @Property(hidden=true, defaultValue="uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources", description="Options for the destroy step (1 or more of: none,uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|uploadTemplateClasspathResources)")
    private Set<String> destroyOptions;
    @Property(hidden=true, defaultValue="uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources", description="Options for the noop step (1 or more of: none,uploadArtifactData,uploadClasspathResources,uploadTemplateClasspathResources).")
    @Regex(pattern="(none|uploadArtifactData|uploadClasspathResources|uploadTemplateClasspathResources)")
    private Set<String> noopOptions;
    @Property(required=false, hidden=true, description="Classpath to the script used to inspect the generic container.")
    private String inspectScript;
    @Property(hidden=true, required=false, description="Additional classpath resources that should be uploaded to the working directory before executing the inspect script.")
    private Set<String> inspectClasspathResources = Sets.newHashSet();
    @Property(hidden=true, required=false, description="Additional template classpath resources that should be uploaded to the working directory before executing the inspect script.The template is first rendered and the rendered content copied to a file, with the same name as the template, in the working directory.")
    private Set<String> inspectTemplateClasspathResources = Sets.newHashSet();

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.executedScriptDelegate((ConfigurationItem)this, name, args, null);
    }

    @Inspect
    public void inspectContainer(InspectionContext ctx) {
        if (Strings.emptyToNull((String)this.getInspectScript()) != null) {
            InspectScriptExecutionStep step = new InspectScriptExecutionStep((ConfigurationItem)this, this.getInspectScript(), (HostContainer)this.getContainer(), this.freeMarkerContext, "Inspect " + this);
            step.setTemplateClasspathResources(Lists.newArrayList(this.getInspectTemplateClasspathResources()));
            step.setClasspathResources(Lists.newArrayList(this.getInspectClasspathResources()));
            ctx.addStep((Step)step);
        }
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public void setRestartRequired(boolean restartRequired) {
        this.restartRequired = restartRequired;
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public void setCreateOrder(int createOrder) {
        this.createOrder = createOrder;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public void setDestroyOrder(int destroyOrder) {
        this.destroyOrder = destroyOrder;
    }

    public int getModifyOrder() {
        return this.modifyOrder;
    }

    public void setModifyOrder(int modifyOrder) {
        this.modifyOrder = modifyOrder;
    }

    public String getCreateVerb() {
        return this.createVerb;
    }

    public void setCreateVerb(String createVerb) {
        this.createVerb = createVerb;
    }

    public String getModifyVerb() {
        return this.modifyVerb;
    }

    public void setModifyVerb(String modifyVerb) {
        this.modifyVerb = modifyVerb;
    }

    public String getDestroyVerb() {
        return this.destroyVerb;
    }

    public void setDestroyVerb(String destroyVerb) {
        this.destroyVerb = destroyVerb;
    }

    public int getNoopOrder() {
        return this.noopOrder;
    }

    public void setNoopOrder(int noopOrder) {
        this.noopOrder = noopOrder;
    }

    public String getNoopVerb() {
        return this.noopVerb;
    }

    public void setNoopVerb(String noopVerb) {
        this.noopVerb = noopVerb;
    }

    public boolean isRestartRequiredForNoop() {
        return this.restartRequiredForNoop;
    }

    public void setRestartRequiredForNoop(boolean restartRequiredForNoop) {
        this.restartRequiredForNoop = restartRequiredForNoop;
    }

    public String getDescription(String verb) {
        return String.format("%s %s on %s", verb, this.getDeployable().getName(), ((HostContainer)this.getContainer()).getName());
    }

    public Map<String, Object> getDeployedAsFreeMarkerContext() {
        return this.freeMarkerContext;
    }

    public Map<String, String> resolveExpression(Map<String, String> expressions) {
        return ConfigurationHolder.resolveExpression(expressions, this.getDeployedAsFreeMarkerContext());
    }

    public Set<String> resolveExpression(Set<String> expressions) {
        return ConfigurationHolder.resolveExpression(expressions, this.getDeployedAsFreeMarkerContext());
    }

    public List<String> resolveExpression(List<String> expressions) {
        return ConfigurationHolder.resolveExpression(expressions, this.getDeployedAsFreeMarkerContext());
    }

    public String resolveExpression(String expression) {
        return ConfigurationHolder.resolveExpression(expression, this.getDeployedAsFreeMarkerContext());
    }

    public Object getPropertyOrContainerDefault(String property) {
        Preconditions.checkNotNull((Object)property, (Object)"Property must not be null.");
        Object o = AbstractDeployed.getProperty((ConfigurationItem)this, property);
        if (o == null) {
            o = AbstractDeployed.getProperty((ConfigurationItem)this.getContainer(), property);
        }
        return o;
    }

    private static Object getProperty(ConfigurationItem ci, String property) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)ci.getType());
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(property);
        if (propertyDescriptor == null) {
            return null;
        }
        return propertyDescriptor.get(ci);
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    public void setDeployedApplication(DeployedApplication deployedApplication) {
        this.deployedApplication = deployedApplication;
    }

    public Operation getPlanOperation() {
        return this.planOperation;
    }

    public void setPlanOperation(Operation planOperation) {
        this.planOperation = planOperation;
    }

    public String getInspectScript() {
        return this.resolveExpression(this.inspectScript);
    }

    public void setInspectScript(String inspectScript) {
        this.inspectScript = inspectScript;
    }

    public Set<String> getInspectClasspathResources() {
        return this.resolveExpression(this.inspectClasspathResources);
    }

    public void setInspectClasspathResources(Set<String> inspectClasspathResources) {
        this.inspectClasspathResources = inspectClasspathResources;
    }

    public Set<String> getInspectTemplateClasspathResources() {
        return this.resolveExpression(this.inspectTemplateClasspathResources);
    }

    public void setInspectTemplateClasspathResources(Set<String> inspectTemplateClasspathResources) {
        this.inspectTemplateClasspathResources = inspectTemplateClasspathResources;
    }

    public Set<String> getCreateOptions() {
        return this.createOptions;
    }

    public Set<String> getModifyOptions() {
        return this.modifyOptions;
    }

    public Set<String> getDestroyOptions() {
        return this.destroyOptions;
    }

    public Set<String> getNoopOptions() {
        return this.noopOptions;
    }

    public void setCreateOptions(Set<String> createOptions) {
        this.createOptions = createOptions;
    }

    public void setModifyOptions(Set<String> modifyOptions) {
        this.modifyOptions = modifyOptions;
    }

    public void setDestroyOptions(Set<String> destroyOptions) {
        this.destroyOptions = destroyOptions;
    }

    public void setNoopOptions(Set<String> noopOptions) {
        this.noopOptions = noopOptions;
    }
}

