/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployed;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;

@Metadata(virtual=true, description="A script executed on a generic container")
public class ExecutedScript<D extends Deployable>
extends AbstractDeployed<D> {
    @Property(required=true, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the create operation.")
    private String createScript;
    @Property(required=false, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the modify operation.")
    private String modifyScript;
    @Property(required=true, hidden=true, description="Classpath to the script that is uploaded and executed on the generic container for the destroy operation.")
    private String destroyScript;

    protected boolean addStep(DeploymentPlanningContext ctx, int order, String script, String verb) {
        if (!Strings.nullToEmpty((String)script).trim().isEmpty()) {
            ctx.addStep((DeploymentStep)new ScriptExecutionStep(order, script, (Container)this.getContainer(), this.getDeployedAsFreeMarkerContext(), this.getDescription(verb)));
            return true;
        }
        return false;
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx) {
        this.addStep(ctx, this.getCreateOrder(), this.getCreateScript(), this.getCreateVerb());
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx) {
        boolean modifyStepAdded = this.addStep(ctx, this.getModifyOrder(), this.getModifyScript(), this.getModifyVerb());
        if (!modifyStepAdded) {
            this.executeDestroy(ctx);
            this.executeCreate(ctx);
        }
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx) {
        this.addStep(ctx, this.getDestroyOrder(), this.getDestroyScript(), this.getDestroyVerb());
    }

    public String getCreateScript() {
        return this.createScript;
    }

    public void setCreateScript(String createScript) {
        this.createScript = createScript;
    }

    public String getModifyScript() {
        return this.modifyScript;
    }

    public void setModifyScript(String modifyScript) {
        this.modifyScript = modifyScript;
    }

    public String getDestroyScript() {
        return this.destroyScript;
    }

    public void setDestroyScript(String destroyScript) {
        this.destroyScript = destroyScript;
    }
}

