/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.step.GenericBaseStep;
import com.xebialabs.overthere.OverthereFile;

public class ArtifactCopyStep
extends GenericBaseStep {
    private String targetPath;
    private boolean createTargetPath;
    private String targetFileName;
    private OverthereFile sourceFile;
    private String sourceFileDescription;
    private String description;

    public ArtifactCopyStep(int order, OverthereFile sourceFile, Container container, String targetPath) {
        super(order, container);
        this.sourceFile = sourceFile;
        this.targetPath = targetPath;
        Preconditions.checkNotNull((Object)targetPath);
    }

    @Override
    protected Step.Result doExecute() throws Exception {
        Preconditions.checkNotNull((Object)this.targetFileName);
        OverthereFile localFile = this.resolveSourceFile();
        Preconditions.checkNotNull((Object)localFile);
        OverthereFile remoteDir = this.getRemoteConnection().getFile(this.targetPath);
        if (!remoteDir.exists()) {
            if (this.createTargetPath) {
                this.getCtx().logOutput("Creating path " + this.targetPath + " on host " + this.getContainer().getHost());
                remoteDir.mkdirs();
            } else if (localFile.isFile()) {
                this.getCtx().logError("Path " + this.targetPath + " on host " + this.getContainer().getHost() + " does not exist.");
                return Step.Result.Fail;
            }
        }
        OverthereFile remoteFile = localFile.isDirectory() ? remoteDir : remoteDir.getFile(this.getTargetFileName());
        this.getCtx().logOutput("Copying " + localFile.getPath() + " to " + remoteFile.getPath() + " on host " + this.getContainer().getHost());
        localFile.copyTo(remoteFile);
        return Step.Result.Success;
    }

    protected OverthereFile resolveSourceFile() {
        Preconditions.checkNotNull((Object)this.sourceFile);
        return this.sourceFile;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return "Copying " + this.getSourceFileDescription() + " to " + this.getContainer().getHost();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSourceFileDescription() {
        return this.sourceFileDescription;
    }

    public void setSourceFileDescription(String sourceFileDescription) {
        this.sourceFileDescription = sourceFileDescription;
    }

    public boolean isCreateTargetPath() {
        return this.createTargetPath;
    }

    public void setCreateTargetPath(boolean createTargetPath) {
        this.createTargetPath = createTargetPath;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }
}

