/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.ci.Container;
import com.xebialabs.deployit.plugin.generic.freemarker.CiAwareObjectWrapper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.generic.freemarker.FileUploader;
import com.xebialabs.deployit.plugin.generic.step.GenericBaseStep;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.util.OverthereUtils;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.MDC;

public class ScriptExecutionStep
extends GenericBaseStep {
    private static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    private String scriptTemplatePath;
    private Map<String, Object> vars;

    public ScriptExecutionStep(int order, String scriptPath, Container container, Map<String, Object> vars, String description) {
        super(order, description, container);
        this.scriptTemplatePath = scriptPath;
        this.vars = vars;
        Preconditions.checkNotNull((Object)this.scriptTemplatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Step.Result doExecute() throws Exception {
        MDC.put((String)MDC_KEY_SCRIPT_PATH, (String)this.scriptTemplatePath);
        try {
            String osSpecificTemplate = this.resolveOsSpecificTemplate();
            String executableContent = this.evaluateTemplate(osSpecificTemplate, this.vars);
            this.logger.debug(executableContent);
            OverthereFile executable = this.uploadExecutable(executableContent, this.substringAfterLast(osSpecificTemplate, '/'));
            CmdLine cmdLine = CmdLine.build((String[])new String[]{executable.getPath()});
            ExecutionContextOverthereProcessOutputHandler handle = new ExecutionContextOverthereProcessOutputHandler((ExecutionContext)this.getCtx());
            this.getCtx().logOutput("Executing " + executable.getPath() + " on host " + this.getContainer().getHost());
            int rc = this.getRemoteConnection().execute((OverthereProcessOutputHandler)handle, cmdLine);
            if (rc != 0) {
                this.getCtx().logError("Execution failed with return code " + rc);
                Step.Result result = Step.Result.Fail;
                return result;
            }
            Step.Result result = Step.Result.Success;
            return result;
        }
        finally {
            MDC.remove((String)MDC_KEY_SCRIPT_PATH);
        }
    }

    private OverthereFile uploadExecutable(String content, String fileName) {
        OverthereFile targetExecutable = this.getRemoteWorkingDirectory().getFile(fileName);
        OverthereUtils.write((byte[])content.getBytes(), (OverthereFile)targetExecutable);
        targetExecutable.setExecutable(true);
        return targetExecutable;
    }

    private String evaluateTemplate(String templatePath, Map<String, Object> vars) {
        Configuration cfg = ConfigurationHolder.getConfiguration();
        try {
            Template template = cfg.getTemplate(templatePath);
            StringWriter sw = new StringWriter();
            template.createProcessingEnvironment(vars, (Writer)sw, (ObjectWrapper)new CiAwareObjectWrapper(new WorkingFolderUploader())).process();
            return sw.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }

    private String resolveOsSpecificTemplate() {
        String osSpecificScript = this.scriptTemplatePath;
        String scriptExt = this.substringAfterLast(this.scriptTemplatePath, '.');
        if (scriptExt == null) {
            OperatingSystemFamily os = this.getContainer().getHost().getOs();
            osSpecificScript = osSpecificScript + os.getScriptExtension();
        }
        if (!this.classpathResourceExists(osSpecificScript)) {
            throw new IllegalArgumentException("Resource " + osSpecificScript + " not found in classpath");
        }
        return osSpecificScript;
    }

    private boolean classpathResourceExists(String resource) {
        return Thread.currentThread().getContextClassLoader().getResource(resource) != null;
    }

    private String substringAfterLast(String str, char sub) {
        int pos = str.lastIndexOf(sub);
        if (pos == -1) {
            return null;
        }
        return str.substring(pos + 1);
    }

    private class WorkingFolderUploader
    implements FileUploader {
        private Map<String, String> uploadedFiles = Maps.newHashMap();

        private WorkingFolderUploader() {
        }

        @Override
        public String upload(OverthereFile file) {
            if (this.uploadedFiles.containsKey(file.getName())) {
                return this.uploadedFiles.get(file.getName());
            }
            OverthereFile uploadedFile = ScriptExecutionStep.this.getRemoteWorkingDirectory().getFile(file.getName());
            file.copyTo(uploadedFile);
            this.uploadedFiles.put(file.getName(), uploadedFile.getPath());
            return uploadedFile.getPath();
        }
    }
}

