/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.generic.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;

@SuppressWarnings("serial")
public class WaitStep implements DeploymentStep {

    private static final int SECONDS_TO_SLEEP = 10;
    private int waitTimeInSeconds = 0;
	private int order;
    private String description;

    public WaitStep(int order, int waitTimeInSeconds, String container, String action) {
		this.waitTimeInSeconds = waitTimeInSeconds;
		this.order = order;
		this.description = "Waiting " + this.waitTimeInSeconds + " seconds for " + container + " to " + action;
	}

	public String getDescription() {
        return description;
	}

	@Override
	public int getOrder() {
		return this.order;
	}

	@Override
	public Result execute(DeploymentExecutionContext ctx){
		int sleepIntervals = waitTimeInSeconds / SECONDS_TO_SLEEP;
	    int remainingSeconds = waitTimeInSeconds % SECONDS_TO_SLEEP;
	
	    ctx.logOutput(description);
		try {
	        int secondsCountDown = waitTimeInSeconds;
	        for(int i=1;i<=sleepIntervals;i++) {
	        	ctx.logOutput("Time remaining " + (secondsCountDown) + " seconds.") ;
	            Thread.sleep((SECONDS_TO_SLEEP*1000));
	            secondsCountDown -= SECONDS_TO_SLEEP;
	        }
	        if (remainingSeconds > 0) {
	        	ctx.logOutput("Time remaining " + remainingSeconds + " seconds.") ;
	             Thread.sleep((remainingSeconds*1000));
	        }
	        ctx.logOutput("Wait complete.");
		} catch (InterruptedException ignored) {
			ctx.logOutput("Wait interupted.") ;
				Thread.currentThread().interrupt();
		}
		return Result.Success;
	}
}
