/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContext;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.generic.step.GenericBaseStep;
import com.xebialabs.deployit.plugin.overthere.ExecutionContextOverthereProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.MDC;

public class ScriptExecutionStep
extends GenericBaseStep {
    private static final String MDC_KEY_SCRIPT_PATH = "scriptPath";
    private String scriptTemplatePath;
    private Map<String, Object> vars;
    private File artifact;
    private List<File> fileResources = Lists.newArrayList();
    private List<String> classpathResources = Lists.newArrayList();
    private List<String> templateClasspathResources = Lists.newArrayList();

    public ScriptExecutionStep(int order, String scriptPath, HostContainer container, Map<String, Object> vars, String description) {
        super(order, description, container);
        this.scriptTemplatePath = scriptPath;
        this.vars = Maps.newHashMap(vars);
        this.vars.put("step", this);
        Preconditions.checkNotNull((Object)this.scriptTemplatePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Step.Result doExecute() throws Exception {
        MDC.put((String)MDC_KEY_SCRIPT_PATH, (String)this.scriptTemplatePath);
        try {
            this.uploadArtifactIfPresent();
            this.uploadFileResources();
            this.uploadClasspathResources();
            this.uploadTemplateClasspathResources();
            OverthereFile executable = this.uploadScriptToExecute(this.scriptTemplatePath);
            this.setWorkingDirectory();
            Step.Result result = this.executeScript(executable);
            return result;
        }
        finally {
            MDC.remove((String)MDC_KEY_SCRIPT_PATH);
        }
    }

    protected OverthereFile uploadArtifactIfPresent() {
        if (this.artifact != null) {
            return this.uploadToWorkingDirectory(this.artifact, this.artifact.getName());
        }
        return null;
    }

    protected void uploadFileResources() {
        for (File fileResource : this.fileResources) {
            String type = fileResource.isDirectory() ? "directory" : "file";
            this.getCtx().logOutput("Uploading " + type + " " + fileResource.getName() + " to working directory.");
            this.uploadToWorkingDirectory(fileResource, fileResource.getName());
        }
    }

    protected void uploadClasspathResources() {
        for (String cpResource : this.classpathResources) {
            this.getCtx().logOutput("Uploading classpath resource " + cpResource + " to working directory.");
            this.uploadResourceToWorkingDirectory(cpResource);
        }
    }

    protected void uploadTemplateClasspathResources() {
        for (String cpTemplate : this.templateClasspathResources) {
            this.uploadTemplateResourceToWorkingDirectory(cpTemplate);
        }
    }

    public OverthereFile uploadTemplateResourceToWorkingDirectory(String template) {
        String osSpecificTemplate = this.resolveOsSpecificTemplate(template);
        String content = this.evaluateTemplate(osSpecificTemplate, this.vars);
        this.logger.debug("Generated content for template {} :\n {} ", (Object)template, (Object)content);
        String fileName = this.resolveOsSpecificFileName(osSpecificTemplate);
        this.logger.debug("Uploading file " + fileName + " to working directory.");
        this.getCtx().logOutput("Uploading file " + fileName + " to working directory.");
        return this.uploadToWorkingDirectory(content, fileName);
    }

    protected void setWorkingDirectory() {
        this.getRemoteConnection().setWorkingDirectory(this.getRemoteWorkingDirectory());
    }

    protected OverthereFile uploadScriptToExecute(String scriptTemplatePath) {
        OverthereFile executable = this.uploadTemplateResourceToWorkingDirectory(scriptTemplatePath);
        executable.setExecutable(true);
        return executable;
    }

    protected Step.Result executeScript(OverthereFile executable) {
        CmdLine cmdLine = CmdLine.build((String[])new String[]{executable.getPath()});
        ExecutionContextOverthereProcessOutputHandler handle = new ExecutionContextOverthereProcessOutputHandler((ExecutionContext)this.getCtx());
        this.getCtx().logOutput("Executing " + executable.getPath() + " on host " + this.getContainer().getHost());
        int rc = this.getRemoteConnection().execute((OverthereProcessOutputHandler)handle, cmdLine);
        if (rc != 0) {
            this.getCtx().logError("Execution failed with return code " + rc);
            return Step.Result.Fail;
        }
        return Step.Result.Success;
    }

    public List<File> getFileResources() {
        return this.fileResources;
    }

    public void setFileResources(List<File> fileResources) {
        this.fileResources = fileResources;
    }

    public List<String> getClasspathResources() {
        return this.classpathResources;
    }

    public void setClasspathResources(List<String> classpathResources) {
        this.classpathResources = classpathResources;
    }

    public List<String> getTemplateClasspathResources() {
        return this.templateClasspathResources;
    }

    public void setTemplateClasspathResources(List<String> templateClasspathResources) {
        this.templateClasspathResources = templateClasspathResources;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public void setArtifact(File artifact) {
        this.artifact = artifact;
    }

    public String getUploadedArtifactPath() {
        if (this.artifact != null) {
            return this.getRemoteWorkingDirectory().getPath() + this.getContainer().getHost().getOs().getFileSeparator() + this.artifact.getName();
        }
        return null;
    }

    protected String resolveOsSpecificFileName(String template) {
        String fileExt;
        String osSpecificFile = this.substringAfterLast(template, '/', template);
        if (osSpecificFile.endsWith(".ftl")) {
            osSpecificFile = osSpecificFile.substring(0, osSpecificFile.lastIndexOf(".ftl"));
        }
        if ((fileExt = this.substringAfterLast(osSpecificFile, '.')) == null) {
            OperatingSystemFamily os = this.getContainer().getHost().getOs();
            osSpecificFile = osSpecificFile + os.getScriptExtension();
        }
        return osSpecificFile;
    }
}

